/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.network;

import homeostatic.common.damagesource.HomeostaticDamageTypes;
import homeostatic.common.effect.HomeostaticEffects;
import homeostatic.common.temperature.BodyTemperature;
import homeostatic.common.temperature.TemperatureThreshold;
import homeostatic.network.ITemperature;
import homeostatic.util.DamageHelper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;

public class Temperature
implements ITemperature {
    private float skinTemperature;
    private float lastSkinTemperature;
    private float coreTemperature;
    private float localTemperature;

    public Temperature() {
        this.skinTemperature = TemperatureThreshold.NORMAL.temperature;
        this.lastSkinTemperature = TemperatureThreshold.NORMAL.temperature;
        this.coreTemperature = TemperatureThreshold.NORMAL.temperature;
        this.localTemperature = 0.0f;
    }

    @Override
    public void setSkinTemperature(float skinTemperature) {
        this.skinTemperature = skinTemperature;
    }

    @Override
    public void setLastSkinTemperature(float lastSkinTemperature) {
        this.lastSkinTemperature = lastSkinTemperature;
    }

    @Override
    public void setCoreTemperature(float coreTemperature) {
        this.coreTemperature = coreTemperature;
    }

    @Override
    public void setLocalTemperature(float temperature) {
        this.localTemperature = temperature;
    }

    @Override
    public void setTemperatureData(float localTemperature, BodyTemperature bodyTemperature) {
        this.setSkinTemperature(bodyTemperature.getSkinTemperature());
        this.setLastSkinTemperature(bodyTemperature.getLastSkinTemperature());
        this.setCoreTemperature(bodyTemperature.getCoreTemperature());
        this.setLocalTemperature(localTemperature);
    }

    @Override
    public float getSkinTemperature() {
        return this.skinTemperature;
    }

    @Override
    public float getLastSkinTemperature() {
        return this.lastSkinTemperature;
    }

    @Override
    public float getCoreTemperature() {
        return this.coreTemperature;
    }

    @Override
    public float getLocalTemperature() {
        return this.localTemperature;
    }

    @Override
    public void checkTemperatureLevel(Player player) {
        float amount;
        if (this.coreTemperature < TemperatureThreshold.LOW.temperature && !player.hasEffect(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)HomeostaticEffects.FROST_RESISTANCE))) {
            player.setTicksFrozen(player.getTicksFrozen() + 5);
        } else if (this.coreTemperature > TemperatureThreshold.HIGH.temperature) {
            amount = (1.0f + (this.coreTemperature - TemperatureThreshold.HIGH.temperature)) * 0.5f;
            player.hurt(new DamageSource(DamageHelper.getHolder(player.getServer(), HomeostaticDamageTypes.HYPERTHERMIA)), amount);
        }
        if (this.skinTemperature > TemperatureThreshold.SCALDING.temperature) {
            amount = (1.0f + (this.skinTemperature - TemperatureThreshold.SCALDING.temperature)) * 0.25f;
            player.hurt(new DamageSource(DamageHelper.getHolder(player.getServer(), HomeostaticDamageTypes.SCALDING)), amount);
        }
    }

    @Override
    public ListTag write() {
        ListTag listTag = new ListTag();
        CompoundTag tag = new CompoundTag();
        this.write(tag);
        listTag.add((Object)tag);
        return listTag;
    }

    @Override
    public CompoundTag write(CompoundTag tag) {
        tag.putFloat("skinTemperature", this.getSkinTemperature());
        tag.putFloat("lastSkinTemperature", this.getLastSkinTemperature());
        tag.putFloat("coreTemperature", this.getCoreTemperature());
        tag.putFloat("localTemperature", this.getLocalTemperature());
        return tag;
    }

    @Override
    public void read(ListTag nbt) {
        this.read(nbt.getCompound(0));
    }

    @Override
    public void read(CompoundTag tag) {
        this.setSkinTemperature(tag.getFloat("skinTemperature"));
        this.setLastSkinTemperature(tag.getFloat("lastSkinTemperature"));
        this.setCoreTemperature(tag.getFloat("coreTemperature"));
        this.setLocalTemperature(tag.getFloat("localTemperature"));
    }
}

