/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import homeostatic.Homeostatic;
import homeostatic.common.Hydration;
import homeostatic.common.effect.HomeostaticEffects;
import homeostatic.overlay.Overlay;
import homeostatic.overlay.WaterHud;
import homeostatic.platform.Services;
import homeostatic.util.WaterHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class HydrationOverlay
extends Overlay {
    public static final ResourceLocation SPRITE = Homeostatic.prefix("textures/gui/icons.png");
    private static float unclampedAlpha = 0.0f;
    private static float alpha = 0.0f;
    private static byte alphaDirection = 1;
    protected static int tickCount = 0;

    @Override
    public void render(GuiGraphics guiGraphics, Minecraft mc, @Nullable BlockPos pos, int scaledWidth, int scaledHeight) {
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack heldItem = player.getMainHandItem();
        Hydration hydration = WaterHelper.getItemHydration(heldItem);
        if (hydration == null) {
            HydrationOverlay.resetAlpha();
            return;
        }
        Gui gui = mc.gui;
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WaterHud.SPRITE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.blendFunc((int)770, (int)771);
        MobEffectInstance effectInstance = mc.player.getEffect(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)HomeostaticEffects.THIRST));
        Services.PLATFORM.getWaterCapabilty((Player)player).ifPresent(data -> {
            int waterLevel = data.getWaterLevel() + hydration.amount();
            float waterSaturationLevel = data.getWaterSaturationLevel() + hydration.saturation();
            WaterHelper.drawWaterBar(SPRITE, scaledWidth, scaledHeight, effectInstance, gui, guiGraphics, waterSaturationLevel, waterLevel, tickCount);
        });
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void onClientTick(Minecraft minecraft) {
        if ((unclampedAlpha += (float)alphaDirection * 0.125f) >= 1.5f) {
            alphaDirection = (byte)-1;
        } else if (unclampedAlpha <= -0.5f) {
            alphaDirection = 1;
        }
        alpha = Math.max(0.0f, Math.min(1.0f, unclampedAlpha)) * Math.min(1.0f, 0.65f);
        ++tickCount;
        tickCount %= 1200;
    }

    public static void resetAlpha() {
        alpha = 0.0f;
        unclampedAlpha = 0.0f;
        alphaDirection = 1;
    }
}

