/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.platform.services;

import homeostatic.common.biome.ClimateSettings;
import homeostatic.common.fluid.FluidInfo;
import homeostatic.common.temperature.BodyTemperature;
import homeostatic.common.temperature.EnvironmentData;
import homeostatic.common.temperature.SubSeason;
import homeostatic.common.temperature.ThermometerInfo;
import homeostatic.common.water.WaterInfo;
import homeostatic.common.wetness.WetnessInfo;
import homeostatic.network.ITemperature;
import homeostatic.network.IThermometer;
import homeostatic.network.IWater;
import homeostatic.network.IWetness;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ServerLevelData;

public interface IPlatform {
    public ResourceLocation getFluidResourceLocation(Fluid var1);

    public double getCreateBlockRadiation(BlockState var1, Double var2);

    public String fluidStackTag();

    public Optional<FluidInfo> getFluidInfo(ItemStack var1);

    public ItemStack drainFluid(ItemStack var1, long var2);

    public ItemStack fillFluid(ItemStack var1, Fluid var2, long var3);

    public long getFluidCapacity(ItemStack var1);

    public Component getDisplayName(Fluid var1);

    public ClimateSettings getClimateSettings(Holder<Biome> var1);

    public SubSeason getSubSeason(ServerLevel var1, Holder<Biome> var2);

    public Optional<? extends ITemperature> getTemperatureData(Player var1);

    public void syncTemperatureData(ServerPlayer var1, EnvironmentData var2, BodyTemperature var3);

    public Optional<? extends IThermometer> getThermometerCapability(Player var1);

    public void syncThermometerData(ServerPlayer var1, ThermometerInfo var2);

    public Optional<? extends IWater> getWaterCapabilty(Player var1);

    public void syncWaterData(ServerPlayer var1, WaterInfo var2);

    public Optional<? extends IWetness> getWetnessCapability(Player var1);

    public void syncWetnessData(ServerPlayer var1, WetnessInfo var2);

    public ServerLevelData getServerLevelData(ServerLevel var1);

    public <T> void registerDataComponent(ResourceLocation var1, DataComponentType<T> var2);

    public boolean isVampire(Player var1);
}

