/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.util;

import homeostatic.common.component.HomeostaticComponents;
import homeostatic.common.fluid.FluidInfo;
import homeostatic.platform.Services;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class ItemStackFluidHelper {
    public static FluidInfo getFluidInfo(ItemStack stack) {
        return new FluidInfo(ItemStackFluidHelper.getFluid(stack), ItemStackFluidHelper.getAmount(stack));
    }

    public static Fluid getFluid(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(HomeostaticComponents.WATER_CONTAINER, (Object)CustomData.EMPTY)).copyTag();
        if (!tag.contains(Services.PLATFORM.fluidStackTag())) {
            ItemStackFluidHelper.setFluid(stack, Fluids.EMPTY);
        }
        String fluidName = tag.getString(Services.PLATFORM.fluidStackTag());
        return (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)fluidName));
    }

    public static void setFluid(ItemStack stack, Fluid fluid) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(HomeostaticComponents.WATER_CONTAINER, (Object)CustomData.EMPTY)).copyTag();
        tag.putString(Services.PLATFORM.fluidStackTag(), Services.PLATFORM.getFluidResourceLocation(fluid).toString());
        stack.set(HomeostaticComponents.WATER_CONTAINER, (Object)CustomData.of((CompoundTag)tag));
    }

    public static void setAmount(ItemStack stack, Long amount) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(HomeostaticComponents.WATER_CONTAINER, (Object)CustomData.EMPTY)).copyTag();
        tag.putLong("Amount", amount.longValue());
        stack.set(HomeostaticComponents.WATER_CONTAINER, (Object)CustomData.of((CompoundTag)tag));
    }

    public static Long getAmount(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(HomeostaticComponents.WATER_CONTAINER, (Object)CustomData.EMPTY)).copyTag();
        if (!tag.contains("Amount")) {
            ItemStackFluidHelper.setAmount(stack, 0L);
        }
        return tag.getLong("Amount");
    }

    public static void drainFluid(ItemStack stack, Long amount) {
        Long currentAmount = ItemStackFluidHelper.getAmount(stack);
        ItemStackFluidHelper.setAmount(stack, Math.max(0L, currentAmount - amount));
        ItemStackFluidHelper.updateDamage(stack);
    }

    public static void fillFluid(ItemStack stack, Fluid fluid, long amount) {
        ItemStackFluidHelper.setFluid(stack, fluid);
        ItemStackFluidHelper.setAmount(stack, amount);
        ItemStackFluidHelper.updateDamage(stack);
    }

    public static void updateDamage(ItemStack stack) {
        if (stack.isDamageableItem()) {
            FluidInfo fluidInfo = ItemStackFluidHelper.getFluidInfo(stack);
            if (stack.isDamageableItem()) {
                stack.setDamageValue(Math.min(stack.getMaxDamage(), stack.getMaxDamage() - (int)fluidInfo.amount()));
            }
        }
    }
}

