/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails;

import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1926;
import net.minecraft.class_1933;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_322;
import net.minecraft.class_326;
import org.dawnoftime.gardentrails.block.IBiomeColoredBlock;
import org.dawnoftime.gardentrails.registry.GTBlocksRegistry;

public class BiomeColorHandlers {
    private static final float BRIGHTNESS_FACTOR = 1.5f;

    private static int brightenColor(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = Math.min(255, (int)((float)r * 1.5f));
        g = Math.min(255, (int)((float)g * 1.5f));
        b = Math.min(255, (int)((float)b * 1.5f));
        return r << 16 | g << 8 | b;
    }

    public static void init() {
        BiomeColorHandlers.registerBiomeColoredBlock(GTBlocksRegistry.INSTANCE.CYPRESS);
        BiomeColorHandlers.registerBiomeColoredBlock(GTBlocksRegistry.INSTANCE.BOXWOOD_BUSH);
        BiomeColorHandlers.registerBiomeColoredBlock(GTBlocksRegistry.INSTANCE.BOXWOOD_SMALL_HEDGE);
        BiomeColorHandlers.registerBiomeColoredBlock(GTBlocksRegistry.INSTANCE.BOXWOOD_TALL_HEDGE);
        BiomeColorHandlers.registerBiomeColoredBlock(() -> GTBlocksRegistry.POT_BLOCKS.get("cypress_flower_pot"));
    }

    private static void registerBiomeColoredBlock(Supplier<class_2248> blockSupplier) {
        class_2248 block = blockSupplier.get();
        if (IBiomeColoredBlock.isBiomeColored(block)) {
            IBiomeColoredBlock coloredBlock = (IBiomeColoredBlock)block;
            class_322 blockColor = (state, world, pos, tintIndex) -> {
                if (world != null && pos != null && tintIndex == 0) {
                    int color = coloredBlock.getColorType() == IBiomeColoredBlock.ColorType.FOLIAGE ? class_1163.method_4966((class_1920)world, (class_2338)pos) : class_1163.method_4962((class_1920)world, (class_2338)pos);
                    return BiomeColorHandlers.brightenColor(color);
                }
                int defaultColor = coloredBlock.getColorType() == IBiomeColoredBlock.ColorType.FOLIAGE ? class_1926.method_8341() : class_1933.method_49724();
                return BiomeColorHandlers.brightenColor(defaultColor);
            };
            class_326 itemColor = (stack, tintIndex) -> {
                if (tintIndex == 0) {
                    int color = coloredBlock.getColorType() == IBiomeColoredBlock.ColorType.FOLIAGE ? class_1926.method_8341() : class_1933.method_49724();
                    return BiomeColorHandlers.brightenColor(color);
                }
                return 0xFFFFFF;
            };
            ColorProviderRegistry.BLOCK.register((Object)blockColor, (Object[])new class_2248[]{block});
            ColorProviderRegistry.ITEM.register((Object)itemColor, (Object[])new class_1935[]{block.method_8389()});
        }
    }
}

