/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.block.german;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import org.dawnoftime.gardentrails.block.IBlockGeneration;
import org.dawnoftime.gardentrails.block.templates.BlockGT;
import org.dawnoftime.gardentrails.platform.Services;
import org.dawnoftime.gardentrails.registry.GTTags;
import org.dawnoftime.gardentrails.util.Utils;
import org.dawnoftime.gardentrails.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class IvyBlock
extends BlockGT
implements IBlockGeneration {
    public static final class_2746 NORTH = class_2741.field_12489;
    public static final class_2746 EAST = class_2741.field_12487;
    public static final class_2746 SOUTH = class_2741.field_12540;
    public static final class_2746 WEST = class_2741.field_12527;
    public static final class_2746 PERSISTENT = class_2741.field_12514;
    private static final class_2758 AGE = class_2741.field_12556;

    public IvyBlock(class_4970.class_2251 properties) {
        super(properties.method_50012(class_3619.field_15971), VoxelShapes.IVY_SHAPES);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0))).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    private static ArrayList<class_2350> getCurrentDirections(class_2680 state) {
        ArrayList<class_2350> list = new ArrayList<class_2350>();
        if (((Boolean)state.method_11654((class_2769)NORTH)).booleanValue()) {
            list.add(class_2350.field_11043);
        }
        if (((Boolean)state.method_11654((class_2769)EAST)).booleanValue()) {
            list.add(class_2350.field_11034);
        }
        if (((Boolean)state.method_11654((class_2769)SOUTH)).booleanValue()) {
            list.add(class_2350.field_11035);
        }
        if (((Boolean)state.method_11654((class_2769)WEST)).booleanValue()) {
            list.add(class_2350.field_11039);
        }
        return list;
    }

    private static class_2746 getProperty(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11035 -> SOUTH;
            case class_2350.field_11039 -> WEST;
            case class_2350.field_11034 -> EAST;
            default -> NORTH;
        };
    }

    private static boolean hasFullFace(class_4538 Level, class_2338 currentPos, class_2350 face) {
        currentPos = currentPos.method_10093(face);
        return IvyBlock.hasFullFace(Level.method_8320(currentPos), Level, currentPos, face);
    }

    private static boolean hasFullFace(class_2680 state, class_4538 Level, class_2338 pos, class_2350 face) {
        class_2248 block = state.method_26204();
        if (block.method_9564().method_26164(class_3481.field_29822) || block.method_9564().method_26164(class_3481.field_15466) || block.method_9564().method_26164(GTTags.INSTANCE.GRAVEL)) {
            return false;
        }
        return class_2248.method_9501((class_265)state.method_26220((class_1922)Level, pos), (class_2350)face.method_10153());
    }

    protected void method_9515(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{NORTH, EAST, SOUTH, WEST, AGE, PERSISTENT});
    }

    @Override
    public int getShapeIndex(@NotNull class_2680 state, @NotNull class_1922 levelIn, @NotNull class_2338 pos, @NotNull class_3726 context) {
        int index = 0;
        if (((Boolean)state.method_11654((class_2769)SOUTH)).booleanValue()) {
            ++index;
        }
        if (((Boolean)state.method_11654((class_2769)WEST)).booleanValue()) {
            index += 2;
        }
        if (((Boolean)state.method_11654((class_2769)NORTH)).booleanValue()) {
            index += 4;
        }
        if (((Boolean)state.method_11654((class_2769)EAST)).booleanValue()) {
            index += 8;
        }
        if (index > 14) {
            index = 0;
        }
        return index;
    }

    public class_2680 method_9605(class_1750 context) {
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = level.method_8320(pos);
        class_2350 facing = context.method_8042();
        if (!IvyBlock.hasFullFace(level.method_8320(pos = pos.method_10093(facing)), (class_4538)level, pos, facing)) {
            return null;
        }
        if (state.method_26204() != this) {
            state = this.method_9564();
        }
        return (class_2680)state.method_11657((class_2769)IvyBlock.getProperty(facing), (Comparable)Boolean.valueOf(true));
    }

    public boolean method_9616(@NotNull class_2680 state, class_1750 useContext) {
        class_1799 itemstack = useContext.method_8041();
        if (useContext.method_8036() != null && useContext.method_8036().method_18276()) {
            return false;
        }
        if (itemstack.method_7909() == this.method_8389()) {
            class_2350 newDirection = useContext.method_8042();
            return switch (newDirection) {
                case class_2350.field_11039 -> {
                    if (!((Boolean)state.method_11654((class_2769)WEST)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case class_2350.field_11043 -> {
                    if (!((Boolean)state.method_11654((class_2769)NORTH)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case class_2350.field_11034 -> {
                    if (!((Boolean)state.method_11654((class_2769)EAST)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                default -> (Boolean)state.method_11654((class_2769)SOUTH) == false;
            };
        }
        return false;
    }

    public boolean method_9542(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)PERSISTENT) == false;
    }

    public void method_9588(@NotNull class_2680 state, class_3218 levelIn, @NotNull class_2338 pos, @NotNull class_5819 random) {
        if (levelIn.method_8608()) {
            return;
        }
        if (!levelIn.method_8477(pos)) {
            return;
        }
        if (levelIn.method_22335(pos, 0) >= 8) {
            int age = (Integer)state.method_11654((class_2769)AGE);
            if (age < 2) {
                if (random.method_43048(Services.PLATFORM.getConfig().climbingPlantGrowthChance) == 0) {
                    levelIn.method_8652(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
                }
                return;
            }
            if (random.method_43048(Services.PLATFORM.getConfig().climbingPlantSpreadChance) == 0) {
                ArrayList<class_2350> faces = IvyBlock.getCurrentDirections(state);
                int startSpread = random.method_43048(4);
                for (class_2350 face : faces) {
                    for (int i = 0; i < 4; ++i) {
                        class_2338 studiedPos;
                        int spreadIndex = (startSpread + i) % 4;
                        if (spreadIndex < 2) {
                            class_2350 rotFace;
                            class_2350 class_23502 = rotFace = spreadIndex == 0 ? face.method_10160() : face.method_10170();
                            if (IvyBlock.hasFullFace((class_4538)levelIn, pos, rotFace)) {
                                if (((Boolean)state.method_11654((class_2769)IvyBlock.getProperty(rotFace))).booleanValue()) continue;
                                levelIn.method_8652(pos, (class_2680)state.method_11657((class_2769)IvyBlock.getProperty(rotFace), (Comparable)Boolean.valueOf(true)), 2);
                                return;
                            }
                            studiedPos = pos.method_10093(rotFace);
                            if (!levelIn.method_8320(studiedPos).method_26215()) continue;
                            if (IvyBlock.hasFullFace((class_4538)levelIn, studiedPos, face)) {
                                levelIn.method_8652(studiedPos, (class_2680)this.method_9564().method_11657((class_2769)IvyBlock.getProperty(face), (Comparable)Boolean.valueOf(true)), 2);
                                return;
                            }
                            if (!levelIn.method_8320(studiedPos = studiedPos.method_10093(face)).method_26215()) continue;
                            class_2350 class_23503 = rotFace = spreadIndex == 0 ? face.method_10170() : face.method_10160();
                            if (!IvyBlock.hasFullFace((class_4538)levelIn, studiedPos, rotFace)) continue;
                            levelIn.method_8652(studiedPos, (class_2680)this.method_9564().method_11657((class_2769)IvyBlock.getProperty(rotFace), (Comparable)Boolean.valueOf(true)), 2);
                            return;
                        }
                        class_2338 class_23382 = studiedPos = spreadIndex == 2 ? pos.method_10084() : pos.method_10074();
                        if (!levelIn.method_8320(studiedPos).method_26215() || !IvyBlock.hasFullFace((class_4538)levelIn, studiedPos, face)) continue;
                        levelIn.method_8652(studiedPos, (class_2680)this.method_9564().method_11657((class_2769)IvyBlock.getProperty(face), (Comparable)Boolean.valueOf(true)), 2);
                        return;
                    }
                }
                levelIn.method_8652(pos, (class_2680)state.method_11657((class_2769)PERSISTENT, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
    }

    @NotNull
    public class_2680 method_9559(@NotNull class_2680 stateIn, class_2350 facing, @NotNull class_2680 facingState, @NotNull class_1936 levelIn, @NotNull class_2338 currentPos, @NotNull class_2338 facingPos) {
        stateIn = (class_2680)stateIn.method_11657((class_2769)PERSISTENT, (Comparable)Boolean.valueOf(false));
        if (facing.method_10166().method_10179()) {
            if (facing == class_2350.field_11043 && ((Boolean)stateIn.method_11654((class_2769)NORTH)).booleanValue() && !IvyBlock.hasFullFace(facingState, (class_4538)levelIn, facingPos, facing)) {
                stateIn = (class_2680)stateIn.method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false));
            }
            if (facing == class_2350.field_11034 && ((Boolean)stateIn.method_11654((class_2769)EAST)).booleanValue() && !IvyBlock.hasFullFace(facingState, (class_4538)levelIn, facingPos, facing)) {
                stateIn = (class_2680)stateIn.method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false));
            }
            if (facing == class_2350.field_11035 && ((Boolean)stateIn.method_11654((class_2769)SOUTH)).booleanValue() && !IvyBlock.hasFullFace(facingState, (class_4538)levelIn, facingPos, facing)) {
                stateIn = (class_2680)stateIn.method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false));
            }
            if (facing == class_2350.field_11039 && ((Boolean)stateIn.method_11654((class_2769)WEST)).booleanValue() && !IvyBlock.hasFullFace(facingState, (class_4538)levelIn, facingPos, facing)) {
                stateIn = (class_2680)stateIn.method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false));
            }
        }
        if (IvyBlock.getCurrentDirections(stateIn).isEmpty()) {
            return class_2246.field_10124.method_9564();
        }
        return stateIn;
    }

    @NotNull
    public class_1269 method_9534(class_2680 state, @NotNull class_1937 levelIn, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_1268 handIn, @NotNull class_3965 hit) {
        if (((Boolean)state.method_11654((class_2769)PERSISTENT)).booleanValue()) {
            if (player.method_7337()) {
                int age = (Integer)state.method_11654((class_2769)AGE);
                if (player.method_18276()) {
                    if (age > 0) {
                        levelIn.method_8652(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(age - 1)), 10);
                        return class_1269.field_5812;
                    }
                } else if (age < 2) {
                    levelIn.method_8652(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(age + 1)), 10);
                    return class_1269.field_5812;
                }
            }
        } else if (Utils.useLighter(levelIn, pos, player, handIn)) {
            Random rand = new Random();
            for (int i = 0; i < 5; ++i) {
                levelIn.method_8494((class_2394)class_2398.field_11251, (double)pos.method_10263() + rand.nextDouble(), (double)pos.method_10264() + 0.5 + rand.nextDouble() / 2.0, (double)pos.method_10260() + rand.nextDouble(), 0.0, 0.07, 0.0);
            }
            levelIn.method_8652(pos, (class_2680)state.method_11657((class_2769)PERSISTENT, (Comparable)Boolean.valueOf(true)), 10);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void method_9568(@NotNull class_1799 stack, @Nullable class_1922 levelIn, @NotNull List<class_2561> tooltip, @NotNull class_1836 flagIn) {
        super.method_9568(stack, levelIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, "crop");
    }

    @Override
    public boolean generateOnPos(class_5281 world, class_2338 pos, class_2680 state, class_5819 random) {
        int trunkSize;
        if (!world.method_8320(pos).method_26164(class_3481.field_15475)) {
            if (world.method_8320(pos.method_10095()).method_26164(class_3481.field_15475)) {
                pos = pos.method_10095();
            } else if (world.method_8320(pos.method_10078()).method_26164(class_3481.field_15475)) {
                pos = pos.method_10078();
            } else if (world.method_8320(pos.method_10072()).method_26164(class_3481.field_15475)) {
                pos = pos.method_10072();
            } else if (world.method_8320(pos.method_10067()).method_26164(class_3481.field_15475)) {
                pos = pos.method_10067();
            } else {
                return false;
            }
        }
        class_2338.class_2339 mutPos = pos.method_25503().method_10098(class_2350.field_11033);
        for (int yDown = 0; yDown < 20; ++yDown) {
            if (!world.method_8320((class_2338)mutPos).method_26164(class_3481.field_15475)) {
                mutPos.method_10098(class_2350.field_11036);
                break;
            }
            mutPos.method_10098(class_2350.field_11033);
        }
        for (trunkSize = 0; trunkSize <= 20 && world.method_8320((class_2338)mutPos).method_26164(class_3481.field_15475); ++trunkSize) {
            mutPos.method_10098(class_2350.field_11036);
        }
        if (trunkSize > 0) {
            return this.tryPlaceOnTrunk(world, pos.method_10095(), (class_2680)state.method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(true)), random, trunkSize) && this.tryPlaceOnTrunk(world, pos.method_10078(), (class_2680)state.method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(true)), random, trunkSize) && this.tryPlaceOnTrunk(world, pos.method_10072(), (class_2680)state.method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(true)), random, trunkSize) && this.tryPlaceOnTrunk(world, pos.method_10067(), (class_2680)state.method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(true)), random, trunkSize);
        }
        return false;
    }

    private boolean tryPlaceOnTrunk(class_5281 world, class_2338 pos, class_2680 state, class_5819 random, int trunkSize) {
        int sideSize;
        class_2338.class_2339 mutPos = pos.method_25503();
        for (sideSize = 0; sideSize < trunkSize && world.method_8320((class_2338)mutPos).method_26215(); ++sideSize) {
            mutPos.method_10098(class_2350.field_11036);
        }
        mutPos = pos.method_25503();
        if (sideSize > 0) {
            sideSize = random.method_43051(1, sideSize + 1);
            for (int yOffset = 0; yOffset < sideSize; ++yOffset) {
                int age = yOffset + 1 == sideSize ? random.method_43048(3) : 2;
                world.method_8652((class_2338)mutPos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(age)), 2);
                mutPos.method_10098(class_2350.field_11036);
            }
            return true;
        }
        return false;
    }
}

