/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.blockentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import org.dawnoftime.gardentrails.platform.Services;
import org.dawnoftime.gardentrails.recipe.DryerRecipe;
import org.dawnoftime.gardentrails.registry.GTBlockEntitiesRegistry;
import org.dawnoftime.gardentrails.registry.GTRecipeTypesRegistry;
import org.jetbrains.annotations.NotNull;

public class DryerBlockEntity
extends class_2586 {
    public final class_1277 itemHandler = new class_1277(2);
    private final int[] remainingTicks = new int[2];
    private boolean isInOperation;

    public DryerBlockEntity(class_2338 pPos, class_2680 pBlockState) {
        super(GTBlockEntitiesRegistry.INSTANCE.DRYER.get(), pPos, pBlockState);
    }

    public void tick() {
        if (this.method_10997() != null && this.isInOperation) {
            int finish = 0;
            boolean success = false;
            for (int slotIndex = 0; slotIndex < this.remainingTicks.length; ++slotIndex) {
                int n = slotIndex;
                this.remainingTicks[n] = this.remainingTicks[n] - 1;
                if (this.remainingTicks[slotIndex] > 0) continue;
                this.remainingTicks[slotIndex] = 0;
                DryerRecipe recipe = this.getDryerRecipe(new class_1277(new class_1799[]{this.itemHandler.method_5438(slotIndex)}));
                if (recipe != null) {
                    this.itemHandler.method_5447(slotIndex, recipe.method_8110(this.method_10997().method_30349()).method_7972());
                    success = true;
                }
                ++finish;
            }
            if (success) {
                this.method_5431();
                class_2680 state = this.field_11863.method_8320(this.field_11867);
                this.method_10997().method_8413(this.field_11867, state, state, 3);
            }
            if (finish >= 2) {
                this.isInOperation = false;
            }
        }
    }

    public class_1269 tryInsertItemStack(class_1799 itemStack, boolean simple, class_1937 worldIn, class_2338 pos, class_1657 player) {
        if (this.putItemStackInFreeSpace(itemStack, simple, player)) {
            return class_1269.field_5812;
        }
        if (simple) {
            if (this.itemIsDried(0)) {
                this.dropItemIndex(0, worldIn, pos);
                this.putItemStackInIndex(0, itemStack, player);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        int index = this.dropOneDriedItem(worldIn, pos);
        if (index < 0) {
            return class_1269.field_5811;
        }
        this.putItemStackInIndex(index, itemStack, player);
        return class_1269.field_5812;
    }

    public class_1269 dropOneItem(class_1937 worldIn, class_2338 pos) {
        if (this.dropOneDriedItem(worldIn, pos) > -1) {
            return class_1269.field_5812;
        }
        if (!this.itemHandler.method_5438(0).method_7960()) {
            this.dropItemIndex(0, worldIn, pos);
            return class_1269.field_5812;
        }
        if (!this.itemHandler.method_5438(1).method_7960()) {
            this.dropItemIndex(1, worldIn, pos);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public int dropOneDriedItem(class_1937 worldIn, class_2338 pos) {
        if (this.itemIsDried(0)) {
            this.dropItemIndex(0, worldIn, pos);
            return 0;
        }
        if (this.itemIsDried(1)) {
            this.dropItemIndex(1, worldIn, pos);
            return 1;
        }
        return -1;
    }

    private boolean itemIsDried(int index) {
        if (this.itemHandler.method_5438(index).method_7960()) {
            return false;
        }
        return this.remainingTicks[index] <= 0;
    }

    private boolean putItemStackInFreeSpace(class_1799 itemStack, boolean simple, class_1657 player) {
        if (this.itemHandler.method_5438(0).method_7960() && this.putItemStackInIndex(0, itemStack, player)) {
            this.isInOperation = true;
            return true;
        }
        if (!simple && this.itemHandler.method_5438(1).method_7960() && this.putItemStackInIndex(1, itemStack, player)) {
            this.isInOperation = true;
            return true;
        }
        return false;
    }

    @Nullable
    private DryerRecipe getDryerRecipe(class_1277 ingredientInventory) {
        if (this.method_10997() != null && !this.method_10997().field_9236) {
            return this.method_10997().method_8433().method_8132(GTRecipeTypesRegistry.INSTANCE.DRYING.get(), (class_1263)ingredientInventory, this.method_10997()).orElse(null);
        }
        return null;
    }

    private boolean putItemStackInIndex(int index, class_1799 itemStack, class_1657 player) {
        class_1277 invInHand;
        DryerRecipe recipe;
        if (this.method_10997() != null && (recipe = this.getDryerRecipe(invInHand = new class_1277(new class_1799[]{itemStack}))) != null && recipe.matches(invInHand, this.method_10997())) {
            float timeVariation;
            this.itemHandler.method_5447(index, ((class_1856)recipe.method_8117().get(0)).method_8105()[0].method_7972());
            if (!player.method_7337()) {
                itemStack.method_7934(((class_1856)recipe.method_8117().get(0)).method_8105()[0].method_7947());
            }
            int range = (timeVariation = new Random().nextFloat() * 2.0f - 1.0f) >= 0.0f ? Services.PLATFORM.getConfig().dryingTimeVariation : 10000 / (100 + Services.PLATFORM.getConfig().dryingTimeVariation);
            this.remainingTicks[index] = (int)((float)recipe.getDryingTime() * (100.0f + timeVariation * (float)range) / 100.0f);
            this.method_5431();
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            this.method_10997().method_8413(this.field_11867, state, state, 3);
            return true;
        }
        return false;
    }

    private void dropItemIndex(int index, class_1937 worldIn, class_2338 pos) {
        class_2248.method_9577((class_1937)worldIn, (class_2338)pos, (class_1799)this.itemHandler.method_5434(index, 64));
        this.remainingTicks[index] = 0;
        if (this.method_10997() != null) {
            class_2680 state = this.method_10997().method_8320(pos);
            this.method_5431();
            this.method_10997().method_8413(this.field_11867, state, state, 2);
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        if (!this.itemHandler.method_5438(0).method_7960()) {
            tag.method_10566("slot_0", (class_2520)this.itemHandler.method_5438(0).method_7953(new class_2487()));
        }
        if (!this.itemHandler.method_5438(1).method_7960()) {
            tag.method_10566("slot_1", (class_2520)this.itemHandler.method_5438(1).method_7953(new class_2487()));
        }
        tag.method_10556("isInOperation", this.isInOperation);
        return tag;
    }

    public void method_11007(@NotNull class_2487 tag) {
        if (!this.itemHandler.method_5438(0).method_7960()) {
            tag.method_10566("slot_0", (class_2520)this.itemHandler.method_5438(0).method_7953(new class_2487()));
        }
        if (!this.itemHandler.method_5438(1).method_7960()) {
            tag.method_10566("slot_1", (class_2520)this.itemHandler.method_5438(1).method_7953(new class_2487()));
        }
        for (int index = 0; index < 2; ++index) {
            tag.method_10569("remainingTime" + index, this.remainingTicks[index]);
        }
        tag.method_10556("isInOperation", this.isInOperation);
        super.method_11007(tag);
    }

    public void method_11014(@NotNull class_2487 tag) {
        this.itemHandler.method_5448();
        class_1799 stack = class_1799.method_7915((class_2487)tag.method_10562("slot_0"));
        if (!stack.method_7960()) {
            this.itemHandler.method_5447(0, stack);
        }
        if (!(stack = class_1799.method_7915((class_2487)tag.method_10562("slot_1"))).method_7960()) {
            this.itemHandler.method_5447(1, stack);
        }
        for (int index = 0; index < 2; ++index) {
            this.remainingTicks[index] = tag.method_10550("remainingTime" + index);
        }
        this.isInOperation = tag.method_10577("isInOperation");
        super.method_11014(tag);
    }
}

