/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.entity;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1315;
import net.minecraft.class_1421;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import org.dawnoftime.gardentrails.block.templates.DoubleGrowingBushBlock;
import org.dawnoftime.gardentrails.platform.Services;
import org.dawnoftime.gardentrails.registry.GTBlocksRegistry;
import org.dawnoftime.gardentrails.registry.GTEntitiesRegistry;

public class SilkmothEntity
extends class_1421 {
    private static final class_2940<class_2338> ROTATION_POS = class_2945.method_12791(SilkmothEntity.class, (class_2941)class_2943.field_13324);
    private static final class_2940<Boolean> CLOCKWISE = class_2945.method_12791(SilkmothEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> DISTANCE = class_2945.method_12791(SilkmothEntity.class, (class_2941)class_2943.field_13320);

    public SilkmothEntity(class_1937 worldIn) {
        super(GTEntitiesRegistry.INSTANCE.SILKMOTH_ENTITY.get(), worldIn);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 3.0);
    }

    private float getNewRotationDistance() {
        return 0.5f + (float)Services.PLATFORM.getConfig().silkmothRotationMaxRange * this.field_5974.method_43057();
    }

    public void method_5773() {
        super.method_5773();
        this.method_18799(this.method_18798().method_18805(1.0, 0.6, 1.0));
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficultyInstance, class_3730 spawnReason, @Nullable class_1315 data, @Nullable class_2487 nbt) {
        this.method_5841().method_12778(ROTATION_POS, (Object)this.method_24515());
        return super.method_5943(world, difficultyInstance, spawnReason, data, nbt);
    }

    protected void method_5958() {
        double alpha;
        super.method_5958();
        if (this.field_6012 >= 24000 && !this.method_16914() && Services.PLATFORM.getConfig().silkmothMustDie) {
            this.method_5643(this.method_48923().method_48825(), 20.0f);
        }
        if (this.field_5974.method_43048(Services.PLATFORM.getConfig().silkmothRotationChange) == 0) {
            this.changeRotationPos();
        }
        class_2338 pos = (class_2338)this.method_5841().method_12789(ROTATION_POS);
        double distance = ((Float)this.method_5841().method_12789(DISTANCE)).floatValue();
        double x = this.method_23317() - ((double)pos.method_10263() + 0.5);
        double z = this.method_23321() - ((double)pos.method_10260() + 0.5);
        if (z == 0.0) {
            alpha = x > 0.0 ? 0.0 : Math.PI;
        } else {
            alpha = Math.atan(z / x);
            if (x > 0.0) {
                alpha += Math.PI;
            }
        }
        double d = Math.sqrt(x * x + z * z);
        d = -distance * 2.0 / (d + distance) + 1.0;
        double d2 = (Boolean)this.method_5841().method_12789(CLOCKWISE) != false ? d - 1.0 : 1.0 - d;
        class_243 motionVector = this.method_18798();
        this.method_18800(motionVector.field_1352 * 0.5 + Math.cos(alpha += d2 * Math.PI / 2.0) * 0.15, Math.sin((double)this.field_6012 / 20.0) * 0.05, motionVector.field_1350 * 0.5 + Math.sin(alpha) * 0.15);
        float rot = (float)class_3532.method_15338((double)(180.0 * alpha / Math.PI - 90.0));
        this.method_5847(rot);
        this.method_36456(rot);
    }

    private void changeRotationPos() {
        int horizontalRange = 5;
        int verticalRange = 2;
        int x = (int)this.method_37908().method_8532() % 23999;
        boolean isNight = x > 12000 && x < 23000;
        x = (int)Math.floor(this.method_23317()) - horizontalRange;
        int y = (int)Math.floor(this.method_23318()) - verticalRange;
        int z = (int)Math.floor(this.method_23321()) - horizontalRange;
        ArrayList<class_2338> listMulberry = new ArrayList<class_2338>();
        ArrayList<class_2338> listLight = new ArrayList<class_2338>();
        for (int searchX = 0; searchX < 2 * horizontalRange + 1; ++searchX) {
            for (int searchZ = 0; searchZ < 2 * horizontalRange + 1; ++searchZ) {
                for (int searchY = 0; searchY < 2 * verticalRange + 1; ++searchY) {
                    class_2338 pos = new class_2338(x + searchX, y + searchY, z + searchZ);
                    class_2680 state = this.method_37908().method_8320(pos);
                    if (state.method_26204() == GTBlocksRegistry.INSTANCE.MULBERRY.get()) {
                        if (((DoubleGrowingBushBlock)state.method_26204()).isBottomCrop(state)) continue;
                        listMulberry.add(pos);
                        continue;
                    }
                    if (!isNight || state.method_26213() < 14) continue;
                    listLight.add(pos);
                }
            }
        }
        if (!listLight.isEmpty()) {
            this.method_5841().method_12778(ROTATION_POS, (Object)((class_2338)listLight.get(this.field_5974.method_43048(listLight.size()))));
        } else if (!listMulberry.isEmpty()) {
            this.method_5841().method_12778(ROTATION_POS, (Object)((class_2338)listMulberry.get(this.field_5974.method_43048(listMulberry.size()))));
        } else {
            this.method_5841().method_12778(ROTATION_POS, (Object)new class_2338(x + this.field_5974.method_43048(2 * horizontalRange + 1), y + this.field_5974.method_43048(2 * verticalRange + 1), z + this.field_5974.method_43048(2 * horizontalRange + 1)));
        }
        this.method_5841().method_12778(DISTANCE, (Object)Float.valueOf(this.getNewRotationDistance()));
    }

    protected float method_18394(class_4050 poseIn, class_4048 sizeIn) {
        return sizeIn.field_18068 / 2.0f;
    }

    public boolean method_5747(float p_225503_1_, float p_225503_2_, class_1282 damageSource) {
        return false;
    }

    protected void method_5623(double p_184231_1_, boolean p_184231_3_, class_2680 state, class_2338 pos) {
    }

    public boolean method_5696() {
        return true;
    }

    public boolean method_5810() {
        return false;
    }

    protected void method_6087(class_1297 entity) {
    }

    protected void method_6070() {
    }

    protected float method_6107() {
        return 0.2f;
    }

    public float method_6017() {
        return super.method_6017() * 0.9f;
    }

    @Nullable
    public class_3414 method_5994() {
        return !Services.PLATFORM.getConfig().silkmothMute && this.field_5974.method_43048(4) == 0 ? class_3417.field_14925 : null;
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return class_3417.field_14925;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14925;
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(ROTATION_POS, (Object)new class_2338((class_2382)this.method_24515()));
        this.method_5841().method_12784(CLOCKWISE, (Object)this.field_5974.method_43056());
        this.method_5841().method_12784(DISTANCE, (Object)Float.valueOf(this.getNewRotationDistance()));
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.method_5841().method_12778(ROTATION_POS, (Object)new class_2338(compound.method_10550("RotationX"), compound.method_10550("RotationY"), compound.method_10550("RotationZ")));
        this.method_5841().method_12778(CLOCKWISE, (Object)compound.method_10577("RotationClockwise"));
        this.method_5841().method_12778(DISTANCE, (Object)Float.valueOf(compound.method_10583("RotationDistance")));
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("RotationX", ((class_2338)this.method_5841().method_12789(ROTATION_POS)).method_10263());
        compound.method_10569("RotationY", ((class_2338)this.method_5841().method_12789(ROTATION_POS)).method_10264());
        compound.method_10569("RotationZ", ((class_2338)this.method_5841().method_12789(ROTATION_POS)).method_10260());
        compound.method_10556("RotationClockwise", ((Boolean)this.method_5841().method_12789(CLOCKWISE)).booleanValue());
        compound.method_10548("RotationDistance", ((Float)this.method_5841().method_12789(DISTANCE)).floatValue());
    }
}

