/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.loot;

import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.minecraft.class_117;
import net.minecraft.class_141;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_219;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_77;
import org.dawnoftime.gardentrails.GTConfig;
import org.dawnoftime.gardentrails.loot.LootTablesToModify;
import org.dawnoftime.gardentrails.platform.Services;
import org.dawnoftime.gardentrails.registry.GTBlocksRegistry;
import org.dawnoftime.gardentrails.registry.GTItemsRegistry;

public final class GTFabricLootModifier {
    private static final GTConfig config = Services.PLATFORM.getConfig();

    public static void modifyLootTables() {
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            switch (id.toString()) {
                case "minecraft:chests/shipwreck_treasure": {
                    GTFabricLootModifier.buildLootTable(GTItemsRegistry.INSTANCE.SILK.get(), 1.0f, tableBuilder);
                    break;
                }
                case "minecraft:chests/village/village_plains_house": {
                    GTFabricLootModifier.buildLootTable(GTItemsRegistry.INSTANCE.GRAPE.get(), 0.5f, tableBuilder);
                    break;
                }
                case "minecraft:chests/village/village_savanna_house": {
                    GTFabricLootModifier.buildLootTable(GTBlocksRegistry.INSTANCE.MAIZE.get().method_8389(), 0.5f, tableBuilder);
                    break;
                }
                case "minecraft:chests/village/village_taiga_house": {
                    GTFabricLootModifier.buildLootTable(GTBlocksRegistry.INSTANCE.RICE.get().method_8389(), 0.5f, tableBuilder);
                    GTFabricLootModifier.buildLootTable(GTBlocksRegistry.INSTANCE.MULBERRY.get().method_8389(), 0.5f, tableBuilder);
                    break;
                }
                case "minecraft:chests/shipwreck_supply": {
                    GTFabricLootModifier.buildLootTable(GTItemsRegistry.INSTANCE.GRAPE.get(), 0.2f, tableBuilder);
                    GTFabricLootModifier.buildLootTable(GTBlocksRegistry.INSTANCE.MAIZE.get().method_8389(), 0.2f, tableBuilder);
                    GTFabricLootModifier.buildLootTable(GTBlocksRegistry.INSTANCE.RICE.get().method_8389(), 0.2f, tableBuilder);
                    GTFabricLootModifier.buildLootTable(GTBlocksRegistry.INSTANCE.MULBERRY.get().method_8389(), 0.2f, tableBuilder);
                }
            }
        });
    }

    private static void buildLootTable(class_1792 item, float probability, class_52.class_53 tableBuilder) {
        boolean shouldAdd = LootTablesToModify.SHOULD_ADD_MAP.getOrDefault(item, false);
        if (GTFabricLootModifier.config.generateChestLoot && shouldAdd) {
            class_55.class_56 poolBuilder = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).conditionally(class_219.method_932((float)probability).build());
            poolBuilder.with(class_77.method_411((class_1935)item).method_437(1).method_419()).method_353((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)1.0f)));
            tableBuilder.pool(poolBuilder.method_355());
        }
    }
}

