/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.registry;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import org.dawnoftime.gardentrails.block.IBiomeColoredBlock;
import org.dawnoftime.gardentrails.block.german.GeraniumBlock;
import org.dawnoftime.gardentrails.block.german.IvyBlock;
import org.dawnoftime.gardentrails.block.japanese.MapleLeavesBlock;
import org.dawnoftime.gardentrails.block.japanese.MapleSaplingBlock;
import org.dawnoftime.gardentrails.block.japanese.MapleTrunkBlock;
import org.dawnoftime.gardentrails.block.japanese.MulberryBlock;
import org.dawnoftime.gardentrails.block.japanese.PausedMapleSaplingBlock;
import org.dawnoftime.gardentrails.block.japanese.StickBundleBlock;
import org.dawnoftime.gardentrails.block.precolumbian.WildMaizeBlock;
import org.dawnoftime.gardentrails.block.roman.CypressBlock;
import org.dawnoftime.gardentrails.block.templates.BiomeColoredBushBlock;
import org.dawnoftime.gardentrails.block.templates.BiomeColoredEdgeBlock;
import org.dawnoftime.gardentrails.block.templates.BiomeColoredPlateBlock;
import org.dawnoftime.gardentrails.block.templates.DoubleCropsBlock;
import org.dawnoftime.gardentrails.block.templates.DryerBlock;
import org.dawnoftime.gardentrails.block.templates.GrowingBushBlock;
import org.dawnoftime.gardentrails.block.templates.PergolaBlock;
import org.dawnoftime.gardentrails.block.templates.PergolaCropBlock;
import org.dawnoftime.gardentrails.block.templates.PergolaPlantBlock;
import org.dawnoftime.gardentrails.block.templates.PlanterBlock;
import org.dawnoftime.gardentrails.block.templates.SoilCropsBlock;
import org.dawnoftime.gardentrails.block.templates.WaterDoubleCropsBlock;
import org.dawnoftime.gardentrails.block.templates.WildPlantBlock;
import org.dawnoftime.gardentrails.item.templates.PotAndBlockItem;
import org.dawnoftime.gardentrails.item.templates.SoilSeedsItem;
import org.dawnoftime.gardentrails.util.Foods;
import org.dawnoftime.gardentrails.util.VoxelShapes;

public abstract class GTBlocksRegistry {
    public static GTBlocksRegistry INSTANCE;
    public static Map<class_6862<class_2248>, Set<Supplier<class_2248>>> blockTagsMap;
    public static final HashMap<String, class_2248> POT_BLOCKS;
    public Supplier<class_2248> CYPRESS;
    public final Supplier<class_2248> BOXWOOD_BUSH = this.register("boxwood_bush", () -> new BiomeColoredBushBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_9988), VoxelShapes.BUSH_SHAPES, IBiomeColoredBlock.ColorType.FOLIAGE), class_3481.field_44469);
    public final Supplier<class_2248> BOXWOOD_TALL_HEDGE = this.register("boxwood_tall_hedge", () -> new BiomeColoredPlateBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_9988), IBiomeColoredBlock.ColorType.FOLIAGE), class_3481.field_44469);
    public final Supplier<class_2248> BOXWOOD_SMALL_HEDGE = this.register("boxwood_small_hedge", () -> new BiomeColoredEdgeBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_9988), IBiomeColoredBlock.ColorType.FOLIAGE), class_3481.field_44469);
    public Supplier<class_2248> IVY;
    public Supplier<class_2248> GERANIUM_PINK;
    public final Supplier<class_2248> PLANTER_GERANIUM_PINK = this.register("planter_geranium_pink", () -> new PlanterBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10460).method_9632(0.6f).method_22488()));
    public final Supplier<class_2248> WILD_GRAPE = this.register("wild_grape", () -> new WildPlantBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10182)), class_3481.field_44469);
    public final Supplier<class_2248> BAMBOO_DRYING_TRAY = this.register("bamboo_drying_tray", () -> new DryerBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10161).method_22488(), VoxelShapes.DRYER_SHAPES), class_3481.field_33713);
    public Supplier<GrowingBushBlock> CAMELLIA;
    public Supplier<MulberryBlock> MULBERRY;
    public final Supplier<WaterDoubleCropsBlock> RICE = this.registerWithItem("rice", () -> new WaterDoubleCropsBlock(2), block -> new SoilSeedsItem(block, null), class_3481.field_33713);
    public final Supplier<class_2248> STICK_BUNDLE = this.register("stick_bundle", () -> new StickBundleBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10126).method_9629(2.0f, 3.0f).method_9626(class_2498.field_11535).method_22488()).setBurnable(), class_3481.field_33713);
    public final Supplier<class_2248> MAPLE_RED_TRUNK = this.registerWithItem("maple_red_trunk", () -> new MapleTrunkBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_9988)), null, class_3481.field_33713);
    public final Supplier<class_2248> MAPLE_RED_LEAVES = this.registerWithItem("maple_red_leaves", () -> new MapleLeavesBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_9988)), null, class_3481.field_33713);
    public Supplier<class_2248> MAPLE_RED_SAPLING;
    public final Supplier<class_2248> PAUSED_MAPLE_RED_SAPLING = this.registerWithItem("paused_maple_red_sapling", () -> new PausedMapleSaplingBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_9988)), null, class_3481.field_33713);
    public Supplier<SoilCropsBlock> COMMELINA;
    public final Supplier<class_2248> WILD_MAIZE = this.register("wild_maize", () -> new WildMaizeBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10182)), class_3481.field_44469);
    public Supplier<DoubleCropsBlock> MAIZE;
    public final Supplier<PergolaBlock> IRON_PERGOLA = this.register("iron_pergola", () -> new PergolaBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10576)));
    public final Supplier<PergolaBlock> IRON_PERGOLA_VINE = this.registerWithItem("iron_pergola_vine", () -> new PergolaPlantBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10576)), null, new class_6862[0]);
    public final Supplier<PergolaBlock> IRON_PERGOLA_IVY = this.registerWithItem("iron_pergola_ivy", () -> new PergolaPlantBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10576)), null, new class_6862[0]);
    public final Supplier<PergolaBlock> IRON_PERGOLA_GRAPE = this.registerWithItem("iron_pergola_grape", () -> new PergolaCropBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10576), 4, 6, 0, 2, 2), null, new class_6862[0]);

    public void postRegister() {
        this.CYPRESS = this.registerWithFlowerPotItem("cypress", () -> new CypressBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_9988).method_9640()).setBurnable(), block -> new PotAndBlockItem((class_2248)block, new class_1792.class_1793()));
        this.MAIZE = this.registerWithFlowerPotItem("maize", () -> new DoubleCropsBlock(SoilCropsBlock.PlantType.CROP, 4), block -> new SoilSeedsItem(block, Foods.MAIZE));
        this.COMMELINA = this.registerWithFlowerPotItem("commelina", () -> new SoilCropsBlock(SoilCropsBlock.PlantType.PLAINS), block -> new SoilSeedsItem(block, null));
        this.MAPLE_RED_SAPLING = this.registerWithFlowerPotItem("maple_red_sapling", () -> new MapleSaplingBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_9988)), block -> new PotAndBlockItem((class_2248)block, new class_1792.class_1793()));
        this.CAMELLIA = this.registerWithFlowerPotItem("camellia", () -> new GrowingBushBlock(SoilCropsBlock.PlantType.PLAINS, 3), "camellia_seeds", block -> new SoilSeedsItem(block, null));
        this.MULBERRY = this.registerWithFlowerPotItem("mulberry", () -> new MulberryBlock(SoilCropsBlock.PlantType.PLAINS, 3, 2), block -> new SoilSeedsItem(block, Foods.MULBERRY));
        this.IVY = this.registerWithFlowerPotItem("ivy", () -> new IvyBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10597).method_9640().method_9632(0.2f).method_9626(class_2498.field_23083)), block -> new PotAndBlockItem((class_2248)block, new class_1792.class_1793()));
        this.GERANIUM_PINK = this.registerWithFlowerPotItem("geranium_pink", () -> new GeraniumBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10583).method_49229(class_4970.class_2250.field_10656).method_9618().method_9626(class_2498.field_11535)), block -> new PotAndBlockItem((class_2248)block, new class_1792.class_1793()));
    }

    public <T extends class_2248> Supplier<T> register(String id, Supplier<T> block) {
        return this.registerWithItem(id, block, blockObject -> new class_1747(blockObject, new class_1792.class_1793()), new class_6862[0]);
    }

    public <T extends class_2248> Supplier<T> register(String id, Supplier<T> block, class_6862<class_2248> ... tagKeys) {
        return this.registerWithItem(id, block, blockObject -> new class_1747(blockObject, new class_1792.class_1793()), tagKeys);
    }

    public abstract <T extends class_2248, Y extends class_1792> Supplier<T> registerWithItem(String var1, Supplier<T> var2, Function<T, Y> var3, class_6862<class_2248> ... var4);

    public abstract <T extends class_2248, Y extends class_1792> Supplier<T> registerWithFlowerPotItem(String var1, Supplier<T> var2, String var3, Function<T, Y> var4);

    public <T extends class_2248, Y extends class_1792> Supplier<T> registerWithFlowerPotItem(String id, Supplier<T> block, Function<T, Y> item) {
        return this.registerWithFlowerPotItem(id, block, id, item);
    }

    public <T extends class_2248> void addBlockTag(Supplier<T> block, class_6862<class_2248> tag) {
        blockTagsMap.computeIfAbsent(tag, k -> new HashSet()).add(block);
    }

    private static ToIntFunction<class_2680> litBlockEmission(int lightValue) {
        return state -> (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false ? lightValue : 0;
    }

    static {
        blockTagsMap = new HashMap<class_6862<class_2248>, Set<Supplier<class_2248>>>();
        POT_BLOCKS = new HashMap();
    }
}

