/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails;

import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.dawnoftime.gardentrails.block.IBiomeColoredBlock;
import org.dawnoftime.gardentrails.registry.GTBlocksRegistry;

@Mod.EventBusSubscriber(modid="gardentrails", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class BiomeColorHandlers {
    private static final float BRIGHTNESS_FACTOR = 1.5f;

    private static int brightenColor(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = Math.min(255, (int)((float)r * 1.5f));
        g = Math.min(255, (int)((float)g * 1.5f));
        b = Math.min(255, (int)((float)b * 1.5f));
        return r << 16 | g << 8 | b;
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        BiomeColorHandlers.registerBiomeColoredBlock(event, GTBlocksRegistry.INSTANCE.CYPRESS);
        BiomeColorHandlers.registerBiomeColoredBlock(event, GTBlocksRegistry.INSTANCE.BOXWOOD_BUSH);
        BiomeColorHandlers.registerBiomeColoredBlock(event, GTBlocksRegistry.INSTANCE.BOXWOOD_SMALL_HEDGE);
        BiomeColorHandlers.registerBiomeColoredBlock(event, GTBlocksRegistry.INSTANCE.BOXWOOD_TALL_HEDGE);
        BiomeColorHandlers.registerBiomeColoredBlock(event, () -> GTBlocksRegistry.POT_BLOCKS.get("cypress_flower_pot"));
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        BiomeColorHandlers.registerBiomeColoredItem(event, GTBlocksRegistry.INSTANCE.CYPRESS);
        BiomeColorHandlers.registerBiomeColoredItem(event, GTBlocksRegistry.INSTANCE.BOXWOOD_BUSH);
        BiomeColorHandlers.registerBiomeColoredItem(event, GTBlocksRegistry.INSTANCE.BOXWOOD_SMALL_HEDGE);
        BiomeColorHandlers.registerBiomeColoredItem(event, GTBlocksRegistry.INSTANCE.BOXWOOD_TALL_HEDGE);
        BiomeColorHandlers.registerBiomeColoredItem(event, () -> GTBlocksRegistry.POT_BLOCKS.get("cypress_flower_pot"));
    }

    private static void registerBiomeColoredBlock(RegisterColorHandlersEvent.Block event, Supplier<Block> blockSupplier) {
        Block block = blockSupplier.get();
        if (IBiomeColoredBlock.isBiomeColored(block)) {
            IBiomeColoredBlock coloredBlock = (IBiomeColoredBlock)block;
            BlockColor blockColor = (state, world, pos, tintIndex) -> {
                if (world != null && pos != null && tintIndex == 0) {
                    int color = coloredBlock.getColorType() == IBiomeColoredBlock.ColorType.FOLIAGE ? BiomeColors.m_108804_((BlockAndTintGetter)world, (BlockPos)pos) : BiomeColors.m_108793_((BlockAndTintGetter)world, (BlockPos)pos);
                    return BiomeColorHandlers.brightenColor(color);
                }
                int defaultColor = coloredBlock.getColorType() == IBiomeColoredBlock.ColorType.FOLIAGE ? FoliageColor.m_46113_() : GrassColor.m_276205_();
                return BiomeColorHandlers.brightenColor(defaultColor);
            };
            event.register(blockColor, new Block[]{block});
        }
    }

    private static void registerBiomeColoredItem(RegisterColorHandlersEvent.Item event, Supplier<Block> blockSupplier) {
        Block block = blockSupplier.get();
        if (IBiomeColoredBlock.isBiomeColored(block)) {
            IBiomeColoredBlock coloredBlock = (IBiomeColoredBlock)block;
            ItemColor itemColor = (stack, tintIndex) -> {
                if (tintIndex == 0) {
                    int color = coloredBlock.getColorType() == IBiomeColoredBlock.ColorType.FOLIAGE ? FoliageColor.m_46113_() : GrassColor.m_276205_();
                    return BiomeColorHandlers.brightenColor(color);
                }
                return 0xFFFFFF;
            };
            event.register(itemColor, new ItemLike[]{block.m_5456_()});
        }
    }
}

