/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.block.german;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.gardentrails.block.IBlockGeneration;
import org.dawnoftime.gardentrails.block.templates.BlockGT;
import org.dawnoftime.gardentrails.platform.Services;
import org.dawnoftime.gardentrails.registry.GTTags;
import org.dawnoftime.gardentrails.util.Utils;
import org.dawnoftime.gardentrails.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class IvyBlock
extends BlockGT
implements IBlockGeneration {
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.f_61447_;
    private static final IntegerProperty AGE = BlockStateProperties.f_61406_;

    public IvyBlock(BlockBehaviour.Properties properties) {
        super(properties.m_278166_(PushReaction.DESTROY), VoxelShapes.IVY_SHAPES);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    private static ArrayList<Direction> getCurrentDirections(BlockState state) {
        ArrayList<Direction> list = new ArrayList<Direction>();
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            list.add(Direction.NORTH);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            list.add(Direction.EAST);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            list.add(Direction.SOUTH);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            list.add(Direction.WEST);
        }
        return list;
    }

    private static BooleanProperty getProperty(Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
            default -> NORTH;
        };
    }

    private static boolean hasFullFace(LevelReader Level2, BlockPos currentPos, Direction face) {
        currentPos = currentPos.m_121945_(face);
        return IvyBlock.hasFullFace(Level2.m_8055_(currentPos), Level2, currentPos, face);
    }

    private static boolean hasFullFace(BlockState state, LevelReader Level2, BlockPos pos, Direction face) {
        Block block = state.m_60734_();
        if (block.m_49966_().m_204336_(BlockTags.f_144274_) || block.m_49966_().m_204336_(BlockTags.f_13029_) || block.m_49966_().m_204336_(GTTags.INSTANCE.GRAVEL)) {
            return false;
        }
        return Block.m_49918_((VoxelShape)state.m_60812_((BlockGetter)Level2, pos), (Direction)face.m_122424_());
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, AGE, PERSISTENT});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter levelIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = 0;
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            ++index;
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            index += 2;
        }
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            index += 4;
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            index += 8;
        }
        if (index > 14) {
            index = 0;
        }
        return index;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        Direction facing = context.m_8125_();
        if (!IvyBlock.hasFullFace(level.m_8055_(pos = pos.m_121945_(facing)), (LevelReader)level, pos, facing)) {
            return null;
        }
        if (state.m_60734_() != this) {
            state = this.m_49966_();
        }
        return (BlockState)state.m_61124_((Property)IvyBlock.getProperty(facing), (Comparable)Boolean.valueOf(true));
    }

    public boolean m_6864_(@NotNull BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.m_43722_();
        if (useContext.m_43723_() != null && useContext.m_43723_().m_6047_()) {
            return false;
        }
        if (itemstack.m_41720_() == this.m_5456_()) {
            Direction newDirection = useContext.m_8125_();
            return switch (newDirection) {
                case Direction.WEST -> {
                    if (!((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.NORTH -> {
                    if (!((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.EAST -> {
                    if (!((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                default -> (Boolean)state.m_61143_((Property)SOUTH) == false;
            };
        }
        return false;
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)PERSISTENT) == false;
    }

    public void m_213897_(@NotNull BlockState state, ServerLevel levelIn, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (levelIn.m_5776_()) {
            return;
        }
        if (!levelIn.m_46749_(pos)) {
            return;
        }
        if (levelIn.m_45524_(pos, 0) >= 8) {
            int age = (Integer)state.m_61143_((Property)AGE);
            if (age < 2) {
                if (random.m_188503_(Services.PLATFORM.getConfig().climbingPlantGrowthChance) == 0) {
                    levelIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
                }
                return;
            }
            if (random.m_188503_(Services.PLATFORM.getConfig().climbingPlantSpreadChance) == 0) {
                ArrayList<Direction> faces = IvyBlock.getCurrentDirections(state);
                int startSpread = random.m_188503_(4);
                for (Direction face : faces) {
                    for (int i = 0; i < 4; ++i) {
                        BlockPos studiedPos;
                        int spreadIndex = (startSpread + i) % 4;
                        if (spreadIndex < 2) {
                            Direction rotFace;
                            Direction direction = rotFace = spreadIndex == 0 ? face.m_122428_() : face.m_122427_();
                            if (IvyBlock.hasFullFace((LevelReader)levelIn, pos, rotFace)) {
                                if (((Boolean)state.m_61143_((Property)IvyBlock.getProperty(rotFace))).booleanValue()) continue;
                                levelIn.m_7731_(pos, (BlockState)state.m_61124_((Property)IvyBlock.getProperty(rotFace), (Comparable)Boolean.valueOf(true)), 2);
                                return;
                            }
                            studiedPos = pos.m_121945_(rotFace);
                            if (!levelIn.m_8055_(studiedPos).m_60795_()) continue;
                            if (IvyBlock.hasFullFace((LevelReader)levelIn, studiedPos, face)) {
                                levelIn.m_7731_(studiedPos, (BlockState)this.m_49966_().m_61124_((Property)IvyBlock.getProperty(face), (Comparable)Boolean.valueOf(true)), 2);
                                return;
                            }
                            if (!levelIn.m_8055_(studiedPos = studiedPos.m_121945_(face)).m_60795_()) continue;
                            Direction direction2 = rotFace = spreadIndex == 0 ? face.m_122427_() : face.m_122428_();
                            if (!IvyBlock.hasFullFace((LevelReader)levelIn, studiedPos, rotFace)) continue;
                            levelIn.m_7731_(studiedPos, (BlockState)this.m_49966_().m_61124_((Property)IvyBlock.getProperty(rotFace), (Comparable)Boolean.valueOf(true)), 2);
                            return;
                        }
                        BlockPos blockPos = studiedPos = spreadIndex == 2 ? pos.m_7494_() : pos.m_7495_();
                        if (!levelIn.m_8055_(studiedPos).m_60795_() || !IvyBlock.hasFullFace((LevelReader)levelIn, studiedPos, face)) continue;
                        levelIn.m_7731_(studiedPos, (BlockState)this.m_49966_().m_61124_((Property)IvyBlock.getProperty(face), (Comparable)Boolean.valueOf(true)), 2);
                        return;
                    }
                }
                levelIn.m_7731_(pos, (BlockState)state.m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState stateIn, Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor levelIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = (BlockState)stateIn.m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(false));
        if (facing.m_122434_().m_122479_()) {
            if (facing == Direction.NORTH && ((Boolean)stateIn.m_61143_((Property)NORTH)).booleanValue() && !IvyBlock.hasFullFace(facingState, (LevelReader)levelIn, facingPos, facing)) {
                stateIn = (BlockState)stateIn.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false));
            }
            if (facing == Direction.EAST && ((Boolean)stateIn.m_61143_((Property)EAST)).booleanValue() && !IvyBlock.hasFullFace(facingState, (LevelReader)levelIn, facingPos, facing)) {
                stateIn = (BlockState)stateIn.m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false));
            }
            if (facing == Direction.SOUTH && ((Boolean)stateIn.m_61143_((Property)SOUTH)).booleanValue() && !IvyBlock.hasFullFace(facingState, (LevelReader)levelIn, facingPos, facing)) {
                stateIn = (BlockState)stateIn.m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false));
            }
            if (facing == Direction.WEST && ((Boolean)stateIn.m_61143_((Property)WEST)).booleanValue() && !IvyBlock.hasFullFace(facingState, (LevelReader)levelIn, facingPos, facing)) {
                stateIn = (BlockState)stateIn.m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false));
            }
        }
        if (IvyBlock.getCurrentDirections(stateIn).isEmpty()) {
            return Blocks.f_50016_.m_49966_();
        }
        return stateIn;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, @NotNull Level levelIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)PERSISTENT)).booleanValue()) {
            if (player.m_7500_()) {
                int age = (Integer)state.m_61143_((Property)AGE);
                if (player.m_6047_()) {
                    if (age > 0) {
                        levelIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age - 1)), 10);
                        return InteractionResult.SUCCESS;
                    }
                } else if (age < 2) {
                    levelIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 10);
                    return InteractionResult.SUCCESS;
                }
            }
        } else if (Utils.useLighter(levelIn, pos, player, handIn)) {
            Random rand = new Random();
            for (int i = 0; i < 5; ++i) {
                levelIn.m_7107_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + rand.nextDouble(), (double)pos.m_123342_() + 0.5 + rand.nextDouble() / 2.0, (double)pos.m_123343_() + rand.nextDouble(), 0.0, 0.07, 0.0);
            }
            levelIn.m_7731_(pos, (BlockState)state.m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), 10);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_5871_(@NotNull ItemStack stack, @Nullable BlockGetter levelIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_5871_(stack, levelIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, "crop");
    }

    @Override
    public boolean generateOnPos(WorldGenLevel world, BlockPos pos, BlockState state, RandomSource random) {
        int trunkSize;
        if (!world.m_8055_(pos).m_204336_(BlockTags.f_13106_)) {
            if (world.m_8055_(pos.m_122012_()).m_204336_(BlockTags.f_13106_)) {
                pos = pos.m_122012_();
            } else if (world.m_8055_(pos.m_122029_()).m_204336_(BlockTags.f_13106_)) {
                pos = pos.m_122029_();
            } else if (world.m_8055_(pos.m_122019_()).m_204336_(BlockTags.f_13106_)) {
                pos = pos.m_122019_();
            } else if (world.m_8055_(pos.m_122024_()).m_204336_(BlockTags.f_13106_)) {
                pos = pos.m_122024_();
            } else {
                return false;
            }
        }
        BlockPos.MutableBlockPos mutPos = pos.m_122032_().m_122173_(Direction.DOWN);
        for (int yDown = 0; yDown < 20; ++yDown) {
            if (!world.m_8055_((BlockPos)mutPos).m_204336_(BlockTags.f_13106_)) {
                mutPos.m_122173_(Direction.UP);
                break;
            }
            mutPos.m_122173_(Direction.DOWN);
        }
        for (trunkSize = 0; trunkSize <= 20 && world.m_8055_((BlockPos)mutPos).m_204336_(BlockTags.f_13106_); ++trunkSize) {
            mutPos.m_122173_(Direction.UP);
        }
        if (trunkSize > 0) {
            return this.tryPlaceOnTrunk(world, pos.m_122012_(), (BlockState)state.m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(true)), random, trunkSize) && this.tryPlaceOnTrunk(world, pos.m_122029_(), (BlockState)state.m_61124_((Property)WEST, (Comparable)Boolean.valueOf(true)), random, trunkSize) && this.tryPlaceOnTrunk(world, pos.m_122019_(), (BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(true)), random, trunkSize) && this.tryPlaceOnTrunk(world, pos.m_122024_(), (BlockState)state.m_61124_((Property)EAST, (Comparable)Boolean.valueOf(true)), random, trunkSize);
        }
        return false;
    }

    private boolean tryPlaceOnTrunk(WorldGenLevel world, BlockPos pos, BlockState state, RandomSource random, int trunkSize) {
        int sideSize;
        BlockPos.MutableBlockPos mutPos = pos.m_122032_();
        for (sideSize = 0; sideSize < trunkSize && world.m_8055_((BlockPos)mutPos).m_60795_(); ++sideSize) {
            mutPos.m_122173_(Direction.UP);
        }
        mutPos = pos.m_122032_();
        if (sideSize > 0) {
            sideSize = random.m_216339_(1, sideSize + 1);
            for (int yOffset = 0; yOffset < sideSize; ++yOffset) {
                int age = yOffset + 1 == sideSize ? random.m_188503_(3) : 2;
                world.m_7731_((BlockPos)mutPos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age)), 2);
                mutPos.m_122173_(Direction.UP);
            }
            return true;
        }
        return false;
    }
}

