/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.block.japanese;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.dawnoftime.gardentrails.block.japanese.MapleLeavesBlock;
import org.dawnoftime.gardentrails.block.japanese.MapleTrunkBlock;
import org.dawnoftime.gardentrails.block.templates.BushBlockGT;
import org.dawnoftime.gardentrails.registry.GTBlocksRegistry;
import org.dawnoftime.gardentrails.util.VoxelShapes;

public class MapleSaplingBlock
extends BushBlockGT
implements BonemealableBlock {
    public static final IntegerProperty STAGE = BlockStateProperties.f_61387_;

    public MapleSaplingBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.SAPLING_SHAPES);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public InteractionResult m_6227_(BlockState p_225533_1_In, Level p_225533_2_In, BlockPos p_225533_3_In, Player p_225533_4_In, InteractionHand p_225533_5_In, BlockHitResult p_225533_6_In) {
        Item mainItem = p_225533_4_In.m_21205_().m_41720_();
        if (mainItem instanceof FlintAndSteelItem) {
            if (!p_225533_2_In.f_46443_) {
                p_225533_2_In.m_7731_(p_225533_3_In, GTBlocksRegistry.INSTANCE.PAUSED_MAPLE_RED_SAPLING.get().m_49966_(), 35);
                p_225533_2_In.m_5898_(p_225533_4_In, 2001, p_225533_3_In, Block.m_49956_((BlockState)p_225533_1_In));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.m_61104_(new Property[]{STAGE});
    }

    public boolean m_6724_(BlockState blockstateIn) {
        return true;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        if (level.m_46803_(pos.m_7494_()) >= 9 && source.m_188503_(7) == 0) {
            if (!level.m_46749_(pos)) {
                return;
            }
            this.advanceTree(level, pos, state);
        }
    }

    public void advanceTree(ServerLevel level, BlockPos pos, BlockState state) {
        if ((Integer)state.m_61143_((Property)STAGE) == 0) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)STAGE), 4);
        } else {
            MapleSaplingBlock.placeFinalTreeIfPossible((LevelAccessor)level, pos);
        }
    }

    public boolean m_7370_(LevelReader p_176473_1_, BlockPos p_176473_2_, BlockState p_176473_3_, boolean p_176473_4_) {
        return true;
    }

    public boolean m_214167_(Level p_180670_1_, RandomSource p_180670_2_, BlockPos p_180670_3_, BlockState p_180670_4_) {
        return (double)p_180670_1_.f_46441_.m_188501_() < 0.45;
    }

    public void m_214148_(ServerLevel level, RandomSource source, BlockPos pos, BlockState state) {
        this.advanceTree(level, pos, state);
    }

    public boolean m_7923_(BlockState p_220074_1_In) {
        return false;
    }

    public float m_7749_(BlockState p_220080_1_, BlockGetter p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState p_200123_1_, BlockGetter p_200123_2_, BlockPos p_200123_3_) {
        return true;
    }

    @Override
    public boolean generateOnPos(WorldGenLevel world, BlockPos pos, BlockState state, RandomSource random) {
        return MapleSaplingBlock.placeFinalTreeIfPossible((LevelAccessor)world, pos);
    }

    public static boolean isValidForPlacement(LevelAccessor worldIn, BlockPos bottomCenterIn) {
        BlockPos floorCenter = bottomCenterIn.m_7495_();
        BlockState state = worldIn.m_8055_(floorCenter);
        if (!state.m_204336_(BlockTags.f_144274_)) {
            return false;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    state = worldIn.m_8055_(bottomCenterIn.m_7918_(x, y + 1, z));
                    if (state.m_60734_() instanceof AirBlock) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean placeFinalTreeIfPossible(LevelAccessor worldIn, BlockPos centerPosIn) {
        if (MapleSaplingBlock.isValidForPlacement(worldIn, centerPosIn)) {
            Direction direction = Direction.Plane.HORIZONTAL.m_235690_(worldIn.m_213780_());
            worldIn.m_7731_(centerPosIn, (BlockState)GTBlocksRegistry.INSTANCE.MAPLE_RED_TRUNK.get().m_49966_().m_61124_((Property)MapleTrunkBlock.FACING, (Comparable)direction), 10);
            for (int x = -1; x <= 1; ++x) {
                for (int y = 0; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos newBlockPosition = new BlockPos(centerPosIn.m_123341_() + x, centerPosIn.m_123342_() + y + 1, centerPosIn.m_123343_() + z);
                        worldIn.m_7731_(newBlockPosition, (BlockState)((BlockState)((BlockState)((BlockState)GTBlocksRegistry.INSTANCE.MAPLE_RED_LEAVES.get().m_49966_().m_61124_((Property)MapleTrunkBlock.FACING, (Comparable)direction)).m_61124_((Property)MapleLeavesBlock.MULTIBLOCK_X, (Comparable)Integer.valueOf(x + 1))).m_61124_((Property)MapleLeavesBlock.MULTIBLOCK_Y, (Comparable)Integer.valueOf(y))).m_61124_((Property)MapleLeavesBlock.MULTIBLOCK_Z, (Comparable)Integer.valueOf(z + 1)), 10);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

