/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.gardentrails.block.templates.SoilCropsBlock;

public class DoubleCropsBlock
extends SoilCropsBlock {
    private final int growingAge;
    public final VoxelShape[] SHAPES;
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;

    public DoubleCropsBlock(SoilCropsBlock.PlantType plantType, int growingAge) {
        super(plantType);
        this.growingAge = growingAge;
        this.SHAPES = this.makeShapes();
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(0))).m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        int index = (Integer)state.m_61143_((Property)f_52244_);
        if (index >= this.getAgeReachingTopBlock()) {
            index = state.m_61143_(HALF) == Half.BOTTOM ? this.getAgeReachingTopBlock() : index + 1;
        }
        return this.SHAPES[index];
    }

    public VoxelShape[] makeShapes() {
        return new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HALF});
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (this.isBottomCrop(stateIn)) {
            if (facing == Direction.UP) {
                if (facingState.m_60734_() == this && !this.isBottomCrop(facingState)) {
                    return (BlockState)stateIn.m_61124_((Property)PERSISTENT, (Comparable)((Boolean)facingState.m_61143_((Property)PERSISTENT)));
                }
                return (Integer)stateIn.m_61143_((Property)f_52244_) < this.getAgeReachingTopBlock() ? stateIn : this.getRemovedState(stateIn);
            }
        } else if (facing == Direction.DOWN) {
            if (facingState.m_60734_() == this && this.isBottomCrop(facingState)) {
                return (BlockState)((BlockState)stateIn.m_61124_((Property)f_52244_, (Comparable)((Integer)facingState.m_61143_((Property)f_52244_)))).m_61124_((Property)PERSISTENT, (Comparable)((Boolean)facingState.m_61143_((Property)PERSISTENT)));
            }
            return this.getRemovedState(stateIn);
        }
        return stateIn;
    }

    @Override
    public void setPlantWithAge(BlockState currentState, LevelAccessor worldIn, BlockPos pos, int newAge) {
        BlockPos posUp;
        if (currentState.m_61143_(HALF) == Half.TOP) {
            pos = pos.m_7495_();
        }
        if (newAge >= this.getAgeReachingTopBlock() && (worldIn.m_8055_(posUp = pos.m_7494_()).m_60734_() == this || worldIn.m_46859_(posUp))) {
            worldIn.m_7731_(posUp, (BlockState)((BlockState)currentState.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(newAge))).m_61124_(HALF, (Comparable)Half.TOP), 10);
        }
        if (newAge < this.getAgeReachingTopBlock() && this.m_52305_(currentState) == this.getAgeReachingTopBlock()) {
            worldIn.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 10);
        }
        worldIn.m_7731_(pos, (BlockState)((BlockState)currentState.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(newAge))).m_61124_(HALF, (Comparable)Half.BOTTOM), 10);
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.m_6240_(worldIn, player, pos, Blocks.f_50016_.m_49966_(), te, stack);
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        Half half = (Half)state.m_61143_(HALF);
        BlockPos otherPos = half == Half.BOTTOM ? pos.m_7494_() : pos.m_7495_();
        BlockState otherState = worldIn.m_8055_(otherPos);
        if (otherState.m_60734_() == this) {
            worldIn.m_7731_(otherPos, this.getRemovedState(otherState), 35);
            worldIn.m_5898_(player, 2001, otherPos, Block.m_49956_((BlockState)otherState));
            ItemStack itemstack = player.m_21205_();
            if (!worldIn.m_5776_() && !player.m_7500_()) {
                Block.m_49881_((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)itemstack);
                Block.m_49881_((BlockState)otherState, (Level)worldIn, (BlockPos)otherPos, null, (Entity)player, (ItemStack)itemstack);
            }
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public BlockState getRemovedState(BlockState state) {
        return Blocks.f_50016_.m_49966_();
    }

    public void m_52263_(Level worldIn, BlockPos pos, BlockState state) {
        if (this.isBottomCrop(state)) {
            BlockPos topPos;
            int newAge = this.m_52305_(state) + this.m_7125_(worldIn);
            if (newAge > this.m_7419_()) {
                newAge = this.m_7419_();
            }
            if (newAge >= this.getAgeReachingTopBlock() && (worldIn.m_8055_(topPos = pos.m_7494_()).m_60734_() == this || worldIn.m_46859_(topPos))) {
                state = this.m_52289_(newAge);
                worldIn.m_7731_(pos, state, 2);
                worldIn.m_7731_(topPos, this.getTopState(state), 2);
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (this.isBottomCrop(state)) {
            int i;
            if (!worldIn.m_46749_(pos) || ((Boolean)state.m_61143_((Property)PERSISTENT)).booleanValue()) {
                return;
            }
            if (worldIn.m_45524_(pos, 0) >= 9 && (i = this.m_52305_(state)) < this.m_7419_()) {
                float f = DoubleCropsBlock.m_52272_((Block)this, (BlockGetter)worldIn, (BlockPos)pos);
                BlockPos topPos = pos.m_7494_();
                if ((worldIn.m_8055_(topPos).m_60734_() == this || worldIn.m_46859_(topPos)) && random.m_188503_((int)(25.0f / f) + 1) == 0) {
                    state = this.m_52289_(i + 1);
                    worldIn.m_7731_(pos, state, 2);
                    if (i + 1 >= this.getAgeReachingTopBlock()) {
                        worldIn.m_7731_(topPos, this.getTopState(state), 2);
                    }
                }
            }
        }
    }

    public boolean isBottomCrop(BlockState state) {
        if (state.m_60734_() instanceof DoubleCropsBlock) {
            return state.m_61143_(HALF) == Half.BOTTOM;
        }
        return false;
    }

    public BlockState getTopState(BlockState bottomState) {
        return (BlockState)bottomState.m_61124_(HALF, (Comparable)Half.TOP);
    }

    public int getAgeReachingTopBlock() {
        return this.growingAge;
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (state.m_61143_(HALF) == Half.TOP) {
            return true;
        }
        return super.m_7898_(state, worldIn, pos);
    }
}

