/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.gardentrails.block.templates.GrowingBushBlock;
import org.dawnoftime.gardentrails.block.templates.SoilCropsBlock;

public class DoubleGrowingBushBlock
extends GrowingBushBlock {
    public final int growingAge;
    public final VoxelShape[] TOP_SHAPES;
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;

    public DoubleGrowingBushBlock(SoilCropsBlock.PlantType plantType, int cutAge, int growingAge) {
        super(plantType, cutAge);
        this.growingAge = growingAge;
        this.TOP_SHAPES = this.makeTopShapes();
        this.m_49959_((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)Half.BOTTOM));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(HALF) == Half.BOTTOM) {
            return this.SHAPES[Math.min(this.m_52305_(state), this.SHAPES.length - 1)];
        }
        return this.TOP_SHAPES[Math.min((Boolean)state.m_61143_((Property)this.getCutProperty()) != false ? this.m_7419_() : this.m_52305_(state), this.TOP_SHAPES.length - 1)];
    }

    @Override
    public VoxelShape[] makeShapes() {
        return new VoxelShape[]{Block.m_49796_((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)6.0, (double)10.5), Block.m_49796_((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)16.0, (double)11.5), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0), (VoxelShape)Block.m_49796_((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)), Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0)};
    }

    public VoxelShape[] makeTopShapes() {
        return new VoxelShape[]{Shapes.m_83040_(), Shapes.m_83040_(), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0)};
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HALF});
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        Half half = (Half)stateIn.m_61143_(HALF);
        if (facing.m_122434_() == Direction.Axis.Y && half == Half.BOTTOM == (facing == Direction.UP)) {
            if (facingState.m_60734_() == this && facingState.m_61143_(HALF) != half) {
                stateIn = (BlockState)stateIn.m_61124_((Property)PERSISTENT, (Comparable)((Boolean)facingState.m_61143_((Property)PERSISTENT)));
                return half == Half.BOTTOM ? stateIn : (BlockState)stateIn.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(this.m_52305_(facingState)));
            }
            if (half == Half.BOTTOM && this.m_52305_(stateIn) < this.growingAge) {
                return stateIn;
            }
            return Blocks.f_50016_.m_49966_();
        }
        return half == Half.BOTTOM && facing == Direction.DOWN && this.m_7898_(stateIn, (LevelReader)worldIn, currentPos.m_7495_()) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.m_6240_(worldIn, player, pos, Blocks.f_50016_.m_49966_(), te, stack);
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        Half half = (Half)state.m_61143_(HALF);
        BlockPos otherPos = half == Half.BOTTOM ? pos.m_7494_() : pos.m_7495_();
        BlockState blockstate = worldIn.m_8055_(otherPos);
        if (blockstate.m_60734_() == this) {
            worldIn.m_7731_(otherPos, Blocks.f_50016_.m_49966_(), 35);
            worldIn.m_5898_(player, 2001, otherPos, Block.m_49956_((BlockState)blockstate));
            ItemStack itemstack = player.m_21205_();
            if (!worldIn.m_5776_() && !player.m_7500_()) {
                Block.m_49881_((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)itemstack);
                Block.m_49881_((BlockState)blockstate, (Level)worldIn, (BlockPos)otherPos, null, (Entity)player, (ItemStack)itemstack);
            }
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    @Override
    public void harvestWithoutBreaking(BlockState state, Level worldIn, BlockPos pos, ItemStack itemStackHand, String blockName, float dropMultiplier) {
        boolean isTop = state.m_61143_(HALF) == Half.TOP;
        worldIn.m_7731_(isTop ? pos.m_7495_() : pos.m_7494_(), (BlockState)((BlockState)((BlockState)state.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(this.cutAge))).m_61124_((Property)this.getCutProperty(), (Comparable)Boolean.valueOf(true))).m_61124_(HALF, (Comparable)(isTop ? Half.BOTTOM : Half.TOP)), 2);
        super.harvestWithoutBreaking(state, worldIn, pos, itemStackHand, blockName, dropMultiplier);
    }

    public void m_52263_(Level worldIn, BlockPos pos, BlockState state) {
        if (this.isBottomCrop(state)) {
            BlockPos topPos;
            int newAge = this.m_52305_(state) + this.m_7125_(worldIn);
            if (newAge > this.m_7419_()) {
                newAge = this.m_7419_();
            }
            if (newAge >= this.getAgeReachingTopBlock() && (worldIn.m_8055_(topPos = pos.m_7494_()).m_60734_() == this || worldIn.m_46859_(topPos))) {
                state = this.m_52289_(newAge);
                worldIn.m_7731_(pos, state, 2);
                worldIn.m_7731_(topPos, this.getTopState(state), 2);
            }
        }
    }

    @Override
    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (this.isBottomCrop(state)) {
            int i;
            if (!worldIn.m_46749_(pos) || ((Boolean)state.m_61143_((Property)PERSISTENT)).booleanValue()) {
                return;
            }
            if (worldIn.m_45524_(pos, 0) >= 9 && (i = this.m_52305_(state)) < this.m_7419_()) {
                float f = DoubleGrowingBushBlock.m_52272_((Block)this, (BlockGetter)worldIn, (BlockPos)pos);
                BlockPos topPos = pos.m_7494_();
                if ((worldIn.m_8055_(topPos).m_60734_() == this || worldIn.m_46859_(topPos)) && random.m_188503_((int)(25.0f / f) + 1) == 0) {
                    state = this.m_52289_(i + 1);
                    worldIn.m_7731_(pos, state, 2);
                    if (i + 1 >= this.growingAge) {
                        worldIn.m_7731_(topPos, this.getTopState(state), 2);
                    }
                }
            }
        }
    }

    public boolean isBottomCrop(BlockState state) {
        if (state.m_60734_() instanceof DoubleGrowingBushBlock) {
            return state.m_61143_(HALF) == Half.BOTTOM;
        }
        return false;
    }

    public BlockState getTopState(BlockState bottomState) {
        return (BlockState)bottomState.m_61124_(HALF, (Comparable)Half.TOP);
    }

    public int getAgeReachingTopBlock() {
        return this.growingAge;
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState stateUnder;
        if (state.m_61143_(HALF) == Half.TOP && (stateUnder = worldIn.m_8055_(pos.m_7495_())).m_60734_() == this) {
            return stateUnder.m_61143_(HALF) == Half.BOTTOM;
        }
        return super.m_7898_(state, worldIn, pos);
    }

    @Override
    public void setPlantWithAge(BlockState currentState, LevelAccessor worldIn, BlockPos pos, int newAge) {
        BlockPos posUp;
        if (currentState.m_61143_(HALF) == Half.TOP) {
            pos = pos.m_7495_();
        }
        if (newAge >= this.getAgeReachingTopBlock() && (worldIn.m_8055_(posUp = pos.m_7494_()).m_60734_() == this || worldIn.m_46859_(posUp))) {
            worldIn.m_7731_(posUp, (BlockState)((BlockState)currentState.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(newAge))).m_61124_(HALF, (Comparable)Half.TOP), 10);
        }
        if (newAge < this.getAgeReachingTopBlock() && this.m_52305_(currentState) == this.getAgeReachingTopBlock()) {
            worldIn.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 10);
        }
        worldIn.m_7731_(pos, (BlockState)((BlockState)currentState.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(newAge))).m_61124_(HALF, (Comparable)Half.BOTTOM), 10);
    }
}

