/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.block.templates;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.gardentrails.block.templates.DoubleCropsBlock;
import org.dawnoftime.gardentrails.block.templates.SoilCropsBlock;

public class WaterDoubleCropsBlock
extends DoubleCropsBlock
implements SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public WaterDoubleCropsBlock(int growingAge) {
        super(SoilCropsBlock.PlantType.WATER, growingAge);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public VoxelShape[] makeShapes() {
        return new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Override
    public BlockState getRemovedState(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Blocks.f_49990_.m_49966_() : super.getRemovedState(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_76152_() == Fluids.f_76193_));
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public BlockState getTopState(BlockState bottomState) {
        return (BlockState)super.getTopState(bottomState).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public void setPlantWithAge(BlockState currentState, LevelAccessor worldIn, BlockPos pos, int newAge) {
        BlockPos posUp;
        if (currentState.m_61143_((Property)HALF) == Half.TOP) {
            pos = pos.m_7495_();
        }
        if (newAge >= this.getAgeReachingTopBlock() && (worldIn.m_8055_(posUp = pos.m_7494_()).m_60734_() == this || worldIn.m_46859_(posUp))) {
            worldIn.m_7731_(posUp, (BlockState)((BlockState)((BlockState)currentState.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(newAge))).m_61124_((Property)HALF, (Comparable)Half.TOP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 10);
        }
        if (newAge < this.getAgeReachingTopBlock() && this.m_52305_(currentState) == this.getAgeReachingTopBlock()) {
            worldIn.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 10);
        }
        worldIn.m_7731_(pos, (BlockState)((BlockState)((BlockState)currentState.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(newAge))).m_61124_((Property)HALF, (Comparable)Half.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 8);
    }
}

