/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.blockentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.dawnoftime.gardentrails.platform.Services;
import org.dawnoftime.gardentrails.recipe.DryerRecipe;
import org.dawnoftime.gardentrails.registry.GTBlockEntitiesRegistry;
import org.dawnoftime.gardentrails.registry.GTRecipeTypesRegistry;
import org.jetbrains.annotations.NotNull;

public class DryerBlockEntity
extends BlockEntity {
    public final SimpleContainer itemHandler = new SimpleContainer(2);
    private final int[] remainingTicks = new int[2];
    private boolean isInOperation;

    public DryerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(GTBlockEntitiesRegistry.INSTANCE.DRYER.get(), pPos, pBlockState);
    }

    public void tick() {
        if (this.m_58904_() != null && this.isInOperation) {
            int finish = 0;
            boolean success = false;
            for (int slotIndex = 0; slotIndex < this.remainingTicks.length; ++slotIndex) {
                int n = slotIndex;
                this.remainingTicks[n] = this.remainingTicks[n] - 1;
                if (this.remainingTicks[slotIndex] > 0) continue;
                this.remainingTicks[slotIndex] = 0;
                DryerRecipe recipe = this.getDryerRecipe(new SimpleContainer(new ItemStack[]{this.itemHandler.m_8020_(slotIndex)}));
                if (recipe != null) {
                    this.itemHandler.m_6836_(slotIndex, recipe.m_8043_(this.m_58904_().m_9598_()).m_41777_());
                    success = true;
                }
                ++finish;
            }
            if (success) {
                this.m_6596_();
                BlockState state = this.f_58857_.m_8055_(this.f_58858_);
                this.m_58904_().m_7260_(this.f_58858_, state, state, 3);
            }
            if (finish >= 2) {
                this.isInOperation = false;
            }
        }
    }

    public InteractionResult tryInsertItemStack(ItemStack itemStack, boolean simple, Level worldIn, BlockPos pos, Player player) {
        if (this.putItemStackInFreeSpace(itemStack, simple, player)) {
            return InteractionResult.SUCCESS;
        }
        if (simple) {
            if (this.itemIsDried(0)) {
                this.dropItemIndex(0, worldIn, pos);
                this.putItemStackInIndex(0, itemStack, player);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        int index = this.dropOneDriedItem(worldIn, pos);
        if (index < 0) {
            return InteractionResult.PASS;
        }
        this.putItemStackInIndex(index, itemStack, player);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult dropOneItem(Level worldIn, BlockPos pos) {
        if (this.dropOneDriedItem(worldIn, pos) > -1) {
            return InteractionResult.SUCCESS;
        }
        if (!this.itemHandler.m_8020_(0).m_41619_()) {
            this.dropItemIndex(0, worldIn, pos);
            return InteractionResult.SUCCESS;
        }
        if (!this.itemHandler.m_8020_(1).m_41619_()) {
            this.dropItemIndex(1, worldIn, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public int dropOneDriedItem(Level worldIn, BlockPos pos) {
        if (this.itemIsDried(0)) {
            this.dropItemIndex(0, worldIn, pos);
            return 0;
        }
        if (this.itemIsDried(1)) {
            this.dropItemIndex(1, worldIn, pos);
            return 1;
        }
        return -1;
    }

    private boolean itemIsDried(int index) {
        if (this.itemHandler.m_8020_(index).m_41619_()) {
            return false;
        }
        return this.remainingTicks[index] <= 0;
    }

    private boolean putItemStackInFreeSpace(ItemStack itemStack, boolean simple, Player player) {
        if (this.itemHandler.m_8020_(0).m_41619_() && this.putItemStackInIndex(0, itemStack, player)) {
            this.isInOperation = true;
            return true;
        }
        if (!simple && this.itemHandler.m_8020_(1).m_41619_() && this.putItemStackInIndex(1, itemStack, player)) {
            this.isInOperation = true;
            return true;
        }
        return false;
    }

    @Nullable
    private DryerRecipe getDryerRecipe(SimpleContainer ingredientInventory) {
        if (this.m_58904_() != null && !this.m_58904_().f_46443_) {
            return this.m_58904_().m_7465_().m_44015_(GTRecipeTypesRegistry.INSTANCE.DRYING.get(), (Container)ingredientInventory, this.m_58904_()).orElse(null);
        }
        return null;
    }

    private boolean putItemStackInIndex(int index, ItemStack itemStack, Player player) {
        SimpleContainer invInHand;
        DryerRecipe recipe;
        if (this.m_58904_() != null && (recipe = this.getDryerRecipe(invInHand = new SimpleContainer(new ItemStack[]{itemStack}))) != null && recipe.matches(invInHand, this.m_58904_())) {
            float timeVariation;
            this.itemHandler.m_6836_(index, ((Ingredient)recipe.m_7527_().get(0)).m_43908_()[0].m_41777_());
            if (!player.m_7500_()) {
                itemStack.m_41774_(((Ingredient)recipe.m_7527_().get(0)).m_43908_()[0].m_41613_());
            }
            int range = (timeVariation = new Random().nextFloat() * 2.0f - 1.0f) >= 0.0f ? Services.PLATFORM.getConfig().dryingTimeVariation : 10000 / (100 + Services.PLATFORM.getConfig().dryingTimeVariation);
            this.remainingTicks[index] = (int)((float)recipe.getDryingTime() * (100.0f + timeVariation * (float)range) / 100.0f);
            this.m_6596_();
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.m_58904_().m_7260_(this.f_58858_, state, state, 3);
            return true;
        }
        return false;
    }

    private void dropItemIndex(int index, Level worldIn, BlockPos pos) {
        Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)this.itemHandler.m_7407_(index, 64));
        this.remainingTicks[index] = 0;
        if (this.m_58904_() != null) {
            BlockState state = this.m_58904_().m_8055_(pos);
            this.m_6596_();
            this.m_58904_().m_7260_(this.f_58858_, state, state, 2);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        if (!this.itemHandler.m_8020_(0).m_41619_()) {
            tag.m_128365_("slot_0", (Tag)this.itemHandler.m_8020_(0).m_41739_(new CompoundTag()));
        }
        if (!this.itemHandler.m_8020_(1).m_41619_()) {
            tag.m_128365_("slot_1", (Tag)this.itemHandler.m_8020_(1).m_41739_(new CompoundTag()));
        }
        tag.m_128379_("isInOperation", this.isInOperation);
        return tag;
    }

    public void m_183515_(@NotNull CompoundTag tag) {
        if (!this.itemHandler.m_8020_(0).m_41619_()) {
            tag.m_128365_("slot_0", (Tag)this.itemHandler.m_8020_(0).m_41739_(new CompoundTag()));
        }
        if (!this.itemHandler.m_8020_(1).m_41619_()) {
            tag.m_128365_("slot_1", (Tag)this.itemHandler.m_8020_(1).m_41739_(new CompoundTag()));
        }
        for (int index = 0; index < 2; ++index) {
            tag.m_128405_("remainingTime" + index, this.remainingTicks[index]);
        }
        tag.m_128379_("isInOperation", this.isInOperation);
        super.m_183515_(tag);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        this.itemHandler.m_6211_();
        ItemStack stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("slot_0"));
        if (!stack.m_41619_()) {
            this.itemHandler.m_6836_(0, stack);
        }
        if (!(stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("slot_1"))).m_41619_()) {
            this.itemHandler.m_6836_(1, stack);
        }
        for (int index = 0; index < 2; ++index) {
            this.remainingTicks[index] = tag.m_128451_("remainingTime" + index);
        }
        this.isInOperation = tag.m_128471_("isInOperation");
        super.m_142466_(tag);
    }
}

