/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.dawnoftime.gardentrails.loot.LootTablesToModify;
import org.dawnoftime.gardentrails.platform.Services;
import org.jetbrains.annotations.NotNull;

public class GTLootModifiersForge
extends LootModifier {
    public static final Supplier<Codec<GTLootModifiersForge>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> GTLootModifiersForge.codecStart((RecordCodecBuilder.Instance)instance).and((App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("item").forGetter(m -> m.item)).apply((Applicative)instance, GTLootModifiersForge::new)));
    private final Item item;

    public GTLootModifiersForge(LootItemCondition[] conditionsIn, Item item) {
        super(conditionsIn);
        this.item = item;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext lootContext) {
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)lootContext)) continue;
            return generatedLoot;
        }
        if (Services.PLATFORM.getConfig().generateChestLoot && LootTablesToModify.SHOULD_ADD_MAP.getOrDefault(this.item, false).booleanValue()) {
            generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
        }
        return generatedLoot;
    }

    @NotNull
    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

