/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.recipe;

import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.dawnoftime.gardentrails.registry.GTBlocksRegistry;
import org.dawnoftime.gardentrails.registry.GTRecipeSerializersRegistry;
import org.dawnoftime.gardentrails.registry.GTRecipeTypesRegistry;
import org.jetbrains.annotations.NotNull;

public class DryerRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    final String group;
    final Ingredient ingredient;
    final ItemStack result;
    final float experience;
    final int dryingTime;

    public DryerRecipe(ResourceLocation resourceLocation, String group, Ingredient ingredient, ItemStack result, float experience, int dryingTime) {
        this.id = resourceLocation;
        this.group = group;
        this.ingredient = ingredient;
        this.result = result;
        this.experience = experience;
        this.dryingTime = dryingTime;
    }

    public int getDryingTime() {
        return this.dryingTime;
    }

    @NotNull
    public String m_6076_() {
        return this.group;
    }

    public boolean matches(SimpleContainer inv, @NotNull Level worldIn) {
        return this.ingredient.test(inv.m_8020_(0)) && inv.m_8020_(0).m_41613_() >= this.ingredient.m_43908_()[0].m_41613_();
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess pRegistryAccess) {
        return this.result;
    }

    @NotNull
    public ItemStack assemble(@NotNull SimpleContainer pContainer, @NotNull RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return GTRecipeSerializersRegistry.INSTANCE.DRYER.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return GTRecipeTypesRegistry.INSTANCE.DRYING.get();
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)this.ingredient);
        return list;
    }

    @NotNull
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)GTBlocksRegistry.INSTANCE.BAMBOO_DRYING_TRAY.get());
    }

    public boolean m_5598_() {
        return true;
    }
}

