/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.dawnoftime.gardentrails.GTCommon;
import org.dawnoftime.gardentrails.GTConfig;
import org.dawnoftime.gardentrails.platform.Services;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Triplet;

public class GTDynamicRecipes {
    private static final GTConfig config = Services.PLATFORM.getConfig();
    public static final String DoT_ID = "dawnoftimebuilder";
    public static JsonObject LIGHT_GRAY_FUTON = null;
    public static JsonObject SMALL_TATAMI_MAT = null;
    public static JsonObject SPRUCE_LEGLESS_CHAIR = null;
    public static JsonObject WHITE_LITTLE_FLAG = null;
    public static JsonObject WHITE_CUSHION = null;
    public static final String AotA_ID = "armoroftheages";
    public static JsonObject RAIJIN_ARMOR_CHEST = null;
    public static JsonObject RAIJIN_ARMOR_LEGS = null;
    public static JsonObject PHARAOH_ARMOR_CHEST = null;
    public static JsonObject PHARAOH_ARMOR_LEGS = null;
    public static JsonObject JAPANESE_LIGHT_ARMOR_HEAD = null;
    public static JsonObject JAPANESE_LIGHT_ARMOR_CHEST = null;
    public static JsonObject JAPANESE_LIGHT_ARMOR_LEGS = null;

    public static void init() {
        if (Services.PLATFORM.isModLoaded(DoT_ID) && GTDynamicRecipes.config.dawnOfTimeUseSilk) {
            LIGHT_GRAY_FUTON = GTDynamicRecipes.createShapedRecipe(RecipeCategory.BUILDING_BLOCKS, new ResourceLocation(DoT_ID, "light_gray_futon"), List.of(GTDynamicRecipes.addItem(Character.valueOf('T'), new ResourceLocation(DoT_ID, "thatch_bamboo")), GTDynamicRecipes.addItem(Character.valueOf('S'), new ResourceLocation("gardentrails", "silk"))), List.of("SSS", "TTT"));
            GTDynamicRecipes.addRecipe(new ResourceLocation(DoT_ID, "light_gray_futon"), LIGHT_GRAY_FUTON);
            SMALL_TATAMI_MAT = GTDynamicRecipes.createShapedRecipe(RecipeCategory.BUILDING_BLOCKS, new ResourceLocation(DoT_ID, "small_tatami_mat"), List.of(GTDynamicRecipes.addItem(Character.valueOf('T'), new ResourceLocation(DoT_ID, "thatch_bamboo_slab")), GTDynamicRecipes.addItem(Character.valueOf('S'), new ResourceLocation("gardentrails", "silk"))), List.of("STS"));
            GTDynamicRecipes.addRecipe(new ResourceLocation(DoT_ID, "small_tatami_mat"), SMALL_TATAMI_MAT);
            SPRUCE_LEGLESS_CHAIR = GTDynamicRecipes.createShapedRecipe(RecipeCategory.BUILDING_BLOCKS, new ResourceLocation(DoT_ID, "spruce_legless_chair"), List.of(GTDynamicRecipes.addItem(Character.valueOf('T'), Items.f_41915_), GTDynamicRecipes.addItem(Character.valueOf('S'), new ResourceLocation("gardentrails", "silk"))), List.of("T  ", "TSS", "TTT"));
            GTDynamicRecipes.addRecipe(new ResourceLocation(DoT_ID, "spruce_legless_chair"), SPRUCE_LEGLESS_CHAIR);
            WHITE_LITTLE_FLAG = GTDynamicRecipes.createShapedRecipe(RecipeCategory.BUILDING_BLOCKS, new ResourceLocation(DoT_ID, "white_little_flag"), List.of(GTDynamicRecipes.addItem(Character.valueOf('T'), Items.f_42398_), GTDynamicRecipes.addItem(Character.valueOf('S'), new ResourceLocation("gardentrails", "silk"))), List.of("TT", "SS"));
            GTDynamicRecipes.addRecipe(new ResourceLocation(DoT_ID, "white_little_flag"), WHITE_LITTLE_FLAG);
            WHITE_CUSHION = GTDynamicRecipes.createShapedRecipe(RecipeCategory.BUILDING_BLOCKS, new ResourceLocation(DoT_ID, "white_cushion"), List.of(GTDynamicRecipes.addItem(Character.valueOf('F'), Items.f_42402_), GTDynamicRecipes.addItem(Character.valueOf('S'), new ResourceLocation("gardentrails", "silk"))), List.of("S  ", "F  ", "S  "));
            GTDynamicRecipes.addRecipe(new ResourceLocation(DoT_ID, "white_cushion"), WHITE_CUSHION);
        }
        if (Services.PLATFORM.isModLoaded(AotA_ID) && GTDynamicRecipes.config.armorOfTheAgesUseSilk) {
            RAIJIN_ARMOR_CHEST = GTDynamicRecipes.createShapedRecipe(RecipeCategory.COMBAT, new ResourceLocation(AotA_ID, "raijin_armor_chest"), List.of(GTDynamicRecipes.addItem(Character.valueOf('R'), Items.f_42153_), GTDynamicRecipes.addItem(Character.valueOf('D'), Items.f_42473_), GTDynamicRecipes.addItem(Character.valueOf('G'), Items.f_41912_), GTDynamicRecipes.addItem(Character.valueOf('S'), new ResourceLocation("gardentrails", "silk"))), List.of("RDR", "SGS", "S S"));
            GTDynamicRecipes.addRecipe(new ResourceLocation(AotA_ID, "raijin_armor_chest"), RAIJIN_ARMOR_CHEST);
            RAIJIN_ARMOR_LEGS = GTDynamicRecipes.createShapedRecipe(RecipeCategory.COMBAT, new ResourceLocation(AotA_ID, "raijin_armor_legs"), List.of(GTDynamicRecipes.addItem(Character.valueOf('R'), Items.f_42497_), GTDynamicRecipes.addItem(Character.valueOf('D'), Items.f_42474_), GTDynamicRecipes.addItem(Character.valueOf('S'), new ResourceLocation("gardentrails", "silk"))), List.of("RDR", "SSS", "S S"));
            GTDynamicRecipes.addRecipe(new ResourceLocation(AotA_ID, "raijin_armor_legs"), RAIJIN_ARMOR_LEGS);
            PHARAOH_ARMOR_CHEST = GTDynamicRecipes.createShapedRecipe(RecipeCategory.COMBAT, new ResourceLocation(AotA_ID, "pharaoh_armor_chest"), List.of(GTDynamicRecipes.addItem(Character.valueOf('G'), Items.f_41912_), GTDynamicRecipes.addItem(Character.valueOf('C'), Items.f_42477_), GTDynamicRecipes.addItem(Character.valueOf('S'), new ResourceLocation("gardentrails", "silk"))), List.of("G G", "SCS", "S S"));
            GTDynamicRecipes.addRecipe(new ResourceLocation(AotA_ID, "pharaoh_armor_chest"), PHARAOH_ARMOR_CHEST);
            PHARAOH_ARMOR_LEGS = GTDynamicRecipes.createShapedRecipe(RecipeCategory.COMBAT, new ResourceLocation(AotA_ID, "pharaoh_armor_legs"), List.of(GTDynamicRecipes.addItem(Character.valueOf('G'), Items.f_41912_), GTDynamicRecipes.addItem(Character.valueOf('L'), Items.f_42478_), GTDynamicRecipes.addItem(Character.valueOf('S'), new ResourceLocation("gardentrails", "silk"))), List.of("SLS", "SGS"));
            GTDynamicRecipes.addRecipe(new ResourceLocation(AotA_ID, "pharaoh_armor_legs"), PHARAOH_ARMOR_LEGS);
            JAPANESE_LIGHT_ARMOR_HEAD = GTDynamicRecipes.createShapedRecipe(RecipeCategory.COMBAT, new ResourceLocation(AotA_ID, "japanese_light_armor_head"), List.of(GTDynamicRecipes.addItem(Character.valueOf('H'), Items.f_42407_), GTDynamicRecipes.addItem(Character.valueOf('S'), new ResourceLocation("gardentrails", "silk"))), List.of("SHS", "  S"));
            GTDynamicRecipes.addRecipe(new ResourceLocation(AotA_ID, "japanese_light_armor_head"), JAPANESE_LIGHT_ARMOR_HEAD);
            JAPANESE_LIGHT_ARMOR_CHEST = GTDynamicRecipes.createShapedRecipe(RecipeCategory.COMBAT, new ResourceLocation(AotA_ID, "japanese_light_armor_chest"), List.of(GTDynamicRecipes.addItem(Character.valueOf('C'), Items.f_42408_), GTDynamicRecipes.addItem(Character.valueOf('L'), Items.f_42454_), GTDynamicRecipes.addItem(Character.valueOf('S'), new ResourceLocation("gardentrails", "silk"))), List.of("S S", "SCS", "LLL"));
            GTDynamicRecipes.addRecipe(new ResourceLocation(AotA_ID, "japanese_light_armor_chest"), JAPANESE_LIGHT_ARMOR_CHEST);
            JAPANESE_LIGHT_ARMOR_LEGS = GTDynamicRecipes.createShapedRecipe(RecipeCategory.COMBAT, new ResourceLocation(AotA_ID, "japanese_light_armor_legs"), List.of(GTDynamicRecipes.addItem(Character.valueOf('P'), Items.f_42462_), GTDynamicRecipes.addItem(Character.valueOf('L'), Items.f_42454_), GTDynamicRecipes.addItem(Character.valueOf('S'), new ResourceLocation("gardentrails", "silk"))), List.of("SPS", "L L"));
            GTDynamicRecipes.addRecipe(new ResourceLocation(AotA_ID, "japanese_light_armor_legs"), JAPANESE_LIGHT_ARMOR_LEGS);
        }
    }

    public static void addRecipe(ResourceLocation recipeId, JsonObject json) {
        GTCommon.dynamicRecipes.add((Tuple<ResourceLocation, JsonObject>)new Tuple((Object)recipeId, (Object)json));
    }

    public static void addRecipe(String recipeId, JsonObject json) {
        GTCommon.dynamicRecipes.add((Tuple<ResourceLocation, JsonObject>)new Tuple((Object)new ResourceLocation("gardentrails", recipeId), (Object)json));
    }

    @NotNull
    public static JsonObject createShapedRecipe(@NotNull RecipeCategory category, Item result, @NotNull List<Triplet<String, Character, ResourceLocation>> keys, @NotNull List<String> pattern) {
        return GTDynamicRecipes.createShapedRecipe(category, BuiltInRegistries.f_257033_.m_7981_((Object)result), keys, pattern);
    }

    @NotNull
    public static JsonObject createShapedRecipe(@NotNull RecipeCategory category, ResourceLocation result, @NotNull List<Triplet<String, Character, ResourceLocation>> keys, @NotNull List<String> pattern) {
        JsonObject mainJson = new JsonObject();
        mainJson.addProperty("type", "minecraft:crafting_shaped");
        mainJson.addProperty("category", category.m_247710_());
        JsonArray jsonArray = new JsonArray();
        for (String s : pattern) {
            jsonArray.add(s);
        }
        mainJson.add("pattern", (JsonElement)jsonArray);
        JsonObject keyList = new JsonObject();
        for (Triplet<String, Character, ResourceLocation> key : keys) {
            JsonObject individualKey = new JsonObject();
            individualKey.addProperty((String)key.getA(), ((ResourceLocation)key.getC()).toString());
            keyList.add("" + key.getB(), (JsonElement)individualKey);
        }
        mainJson.add("key", (JsonElement)keyList);
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("item", result.toString());
        jsonobject.addProperty("count", (Number)1);
        mainJson.add("result", (JsonElement)jsonobject);
        return mainJson;
    }

    public static Triplet<String, Character, ResourceLocation> addItem(Character c, Item item) {
        return new Triplet((Object)"item", (Object)c, (Object)BuiltInRegistries.f_257033_.m_7981_((Object)item));
    }

    public static Triplet<String, Character, ResourceLocation> addItem(Character c, TagKey<Item> tag) {
        return new Triplet((Object)"tag", (Object)c, (Object)tag.f_203868_());
    }

    public static Triplet<String, Character, ResourceLocation> addItem(Character c, ResourceLocation tag, boolean isTag) {
        return new Triplet((Object)(isTag ? "tag" : "item"), (Object)c, (Object)tag);
    }

    public static Triplet<String, Character, ResourceLocation> addItem(Character c, ResourceLocation item) {
        return GTDynamicRecipes.addItem(c, item, false);
    }
}

