/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.recipehandler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;

public interface IRecipeDefinition
extends Comparable<IRecipeDefinition> {
    public Set<IngredientComponent<?, ?>> getInputComponents();

    public <T, M> List<IPrototypedIngredientAlternatives<T, M>> getInputs(IngredientComponent<T, M> var1);

    public <T, M> boolean isInputReusable(IngredientComponent<T, M> var1, int var2);

    public IMixedIngredients getOutput();

    public static void serialize(ValueOutput valueOutput, IRecipeDefinition recipe) {
        ValueOutput.ValueOutputList inputTag = valueOutput.childrenList("input");
        for (IngredientComponent component : recipe.getInputComponents().stream().sorted().toList()) {
            ValueOutput child = inputTag.addChild();
            String componentName = IngredientComponent.REGISTRY.getKey((Object)component).toString();
            child.putString("component", componentName);
            ValueOutput.ValueOutputList instances = child.childrenList("instances");
            List inputs = recipe.getInputs(component);
            int[] reusableBytes = new int[inputs.size()];
            int index = 0;
            for (IPrototypedIngredientAlternatives ingredient : inputs) {
                ValueOutput subTag = instances.addChild();
                IPrototypedIngredientAlternatives.ISerializer<?> serializer = ingredient.getSerializer();
                serializer.serialize(subTag.child("val"), component, ingredient);
                subTag.putByte("type", serializer.getId());
                reusableBytes[index] = recipe.isInputReusable(component, index) ? 1 : 0;
                ++index;
            }
            child.putIntArray("reusable", reusableBytes);
        }
        IMixedIngredients.serialize(valueOutput.child("output"), recipe.getOutput());
    }

    public static RecipeDefinition deserialize(ValueInput valueInput) throws IllegalArgumentException {
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        IdentityHashMap inputsReusable = Maps.newIdentityHashMap();
        for (ValueInput child : (ValueInput.ValueInputList)valueInput.childrenList("input").orElseThrow()) {
            String componentName = (String)child.getString("component").orElseThrow();
            IngredientComponent component = (IngredientComponent)((Holder.Reference)IngredientComponent.REGISTRY.get(ResourceLocation.parse((String)componentName)).orElseThrow(() -> new IllegalArgumentException("Could not find the ingredient component type " + componentName))).value();
            ValueInput.ValueInputList instancesTag = (ValueInput.ValueInputList)child.childrenList("instances").orElseThrow();
            ArrayList instances = Lists.newArrayList();
            for (ValueInput instanceTagCompound : instancesTag) {
                byte type = instanceTagCompound.getByteOr("type", (byte)0);
                IPrototypedIngredientAlternatives.ISerializer alternativeSerializer = (IPrototypedIngredientAlternatives.ISerializer)IPrototypedIngredientAlternatives.SERIALIZERS.get(type);
                if (alternativeSerializer == null) {
                    throw new IllegalArgumentException("Could not find a prototyped ingredient alternative serializer for id " + type);
                }
                Object alternatives = alternativeSerializer.deserialize((ValueInput)instanceTagCompound.child("val").orElseThrow(), component);
                instances.add(alternatives);
            }
            inputs.put(component, instances);
            int[] subTag = (int[])child.getIntArray("reusable").orElseThrow();
            ArrayList inputReusable = Lists.newArrayList();
            for (int b : subTag) {
                inputReusable.add(b == 1);
            }
            inputsReusable.put(component, inputReusable);
        }
        MixedIngredients output = IMixedIngredients.deserialize((ValueInput)valueInput.child("output").orElseThrow());
        return new RecipeDefinition(inputs, inputsReusable, output);
    }
}

