/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.recipehandler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;

public class PrototypedIngredientAlternativesList<T, M>
implements IPrototypedIngredientAlternatives<T, M> {
    public static final Serializer SERIALIZER = new Serializer();
    private final List<IPrototypedIngredient<T, M>> alternatives;

    public PrototypedIngredientAlternativesList(List<IPrototypedIngredient<T, M>> alternatives) {
        this.alternatives = alternatives;
    }

    @Override
    public Collection<IPrototypedIngredient<T, M>> getAlternatives() {
        return this.alternatives;
    }

    @Override
    public IPrototypedIngredientAlternatives.ISerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public boolean equals(Object obj) {
        return obj instanceof IPrototypedIngredientAlternatives && this.getAlternatives().equals(((IPrototypedIngredientAlternatives)obj).getAlternatives());
    }

    public int hashCode() {
        int inputsHash = 333;
        for (IPrototypedIngredient<T, M> value : this.getAlternatives()) {
            inputsHash |= value.hashCode();
        }
        return 0x4D3 | inputsHash << 2;
    }

    public String toString() {
        return "[PrototypedIngredientAlternativesList: " + this.alternatives.toString() + "]";
    }

    public static class Serializer
    implements IPrototypedIngredientAlternatives.ISerializer<PrototypedIngredientAlternativesList<?, ?>> {
        @Override
        public byte getId() {
            return 0;
        }

        @Override
        public <T, M> void serialize(ValueOutput valueOutput, IngredientComponent<T, M> ingredientComponent, PrototypedIngredientAlternativesList<?, ?> alternatives) {
            ValueOutput.ValueOutputList prototypes = valueOutput.childrenList("l");
            IIngredientSerializer serializer = ingredientComponent.getSerializer();
            for (IPrototypedIngredient prototypedIngredient : alternatives.alternatives) {
                ValueOutput prototypeTag = prototypes.addChild();
                serializer.serializeInstance(prototypeTag.child("prototype"), prototypedIngredient.getPrototype());
                prototypeTag.store("condition", ExtraCodecs.NBT, (Object)serializer.serializeCondition(prototypedIngredient.getCondition()));
            }
        }

        @Override
        public <T, M> PrototypedIngredientAlternativesList<?, ?> deserialize(ValueInput valueInput, IngredientComponent<T, M> ingredientComponent) {
            ValueInput.ValueInputList instancesTag = (ValueInput.ValueInputList)valueInput.childrenList("l").orElseThrow();
            ArrayList instances = Lists.newArrayList();
            IIngredientSerializer<T, M> serializer = ingredientComponent.getSerializer();
            for (ValueInput prototypeTag : instancesTag) {
                instances.add(new PrototypedIngredient<T, M>(ingredientComponent, serializer.deserializeInstance((ValueInput)prototypeTag.child("prototype").orElseThrow()), serializer.deserializeCondition((Tag)prototypeTag.read("condition", ExtraCodecs.NBT).orElseThrow())));
            }
            return new PrototypedIngredientAlternativesList(instances);
        }
    }
}

