/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.ingredient;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredientsAdapter;

public class MixedIngredients
extends MixedIngredientsAdapter {
    private final Map<IngredientComponent<?, ?>, List<?>> ingredients;

    public MixedIngredients(Map<IngredientComponent<?, ?>, List<?>> ingredients) {
        this.ingredients = ingredients;
        for (Map.Entry<IngredientComponent<?, ?>, List<?>> entry : this.ingredients.entrySet()) {
            if (!entry.getValue().isEmpty()) continue;
            throw new IllegalArgumentException(String.format("Invalid MixedIngredients input, empty list for %s", entry.getKey().getName()));
        }
    }

    @Override
    public Set<IngredientComponent<?, ?>> getComponents() {
        return this.ingredients.keySet();
    }

    @Override
    public <T> List<T> getInstances(IngredientComponent<T, ?> ingredientComponent) {
        return this.ingredients.getOrDefault(ingredientComponent, Collections.emptyList());
    }

    public static <T> MixedIngredients ofInstances(IngredientComponent<T, ?> component, Collection<T> instances) {
        IdentityHashMap ingredients = Maps.newIdentityHashMap();
        ingredients.put(component, instances instanceof ArrayList ? (List)instances : Lists.newArrayList(instances));
        return new MixedIngredients(ingredients);
    }

    public static <T> MixedIngredients ofInstance(IngredientComponent<T, ?> component, T instance) {
        return MixedIngredients.ofInstances(component, Lists.newArrayList((Object[])new Object[]{instance}));
    }

    public static MixedIngredients fromRecipeInput(IRecipeDefinition recipe) {
        IdentityHashMap ingredients = Maps.newIdentityHashMap();
        for (IngredientComponent<?, ?> component : recipe.getInputComponents()) {
            IIngredientMatcher<?, ?> matcher = component.getMatcher();
            List instances = recipe.getInputs(component).stream().map(ingredient -> {
                IPrototypedIngredient firstIngredient = (IPrototypedIngredient)Iterables.getFirst(ingredient.getAlternatives(), null);
                if (firstIngredient == null) {
                    return matcher.getEmptyInstance();
                }
                return firstIngredient.getPrototype();
            }).collect(Collectors.toList());
            if (instances.isEmpty()) continue;
            ingredients.put(component, instances);
        }
        return new MixedIngredients(ingredients);
    }
}

