/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.potion;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.recipehandler.VanillaRecipeTypeRecipeHandler;

public class PotionHelperCommonCapabilities {
    private static List<IRecipeDefinition> VANILLA_RECIPES = null;

    public static List<IRecipeDefinition> getVanillaRecipes() {
        if (VANILLA_RECIPES == null) {
            VANILLA_RECIPES = Lists.newArrayList();
            ArrayList inputItems = Lists.newArrayList((Object[])new ItemStack[]{PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER)});
            ArrayList ingredients = Lists.newArrayList();
            PotionBrewing potionBrewing = ServerLifecycleHooks.getCurrentServer().potionBrewing();
            for (PotionBrewing.Mix mixPredicate : potionBrewing.containerMixes) {
                ingredients.addAll(VanillaRecipeTypeRecipeHandler.getPrototypesFromIngredient(mixPredicate.ingredient(), null).getAlternatives());
            }
            for (PotionBrewing.Mix mixPredicate : potionBrewing.potionMixes) {
                ingredients.addAll(VanillaRecipeTypeRecipeHandler.getPrototypesFromIngredient(mixPredicate.ingredient(), null).getAlternatives());
            }
            ArrayList checkInputItems = Lists.newArrayList((Iterable)inputItems);
            while (!checkInputItems.isEmpty()) {
                ArrayList newItems = Lists.newArrayList();
                for (ItemStack inputItem : checkInputItems) {
                    PrototypedIngredient<ItemStack, Integer> item = new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, inputItem, 5);
                    for (IPrototypedIngredient ingredient : ingredients) {
                        ItemStack output = potionBrewing.mix(((ItemStack)ingredient.getPrototype()).copy(), inputItem.copy());
                        if (!PotionHelperCommonCapabilities.isPotionOutputValid(inputItem, output)) continue;
                        PotionHelperCommonCapabilities.addRecipeIfNew(ingredient, item, output, newItems);
                    }
                    if (VANILLA_RECIPES.size() <= 7500) continue;
                    throw new RuntimeException("Infinite loop detected! Please report this to the Common Capabilities issue tracker with a list of (potion-changing) mods installed");
                }
                checkInputItems = newItems;
            }
        }
        return VANILLA_RECIPES;
    }

    protected static boolean isPotionOutputValid(ItemStack input, ItemStack output) {
        return !input.isEmpty() && !output.isEmpty() && (input.getItem() != output.getItem() || PotionHelperCommonCapabilities.getPotion(output) != Potions.WATER && !Objects.equals(BuiltInRegistries.POTION.getKey((Object)((Potion)PotionHelperCommonCapabilities.getPotion(output).value())), BuiltInRegistries.POTION.getKey((Object)((Potion)PotionHelperCommonCapabilities.getPotion(input).value()))));
    }

    protected static Holder<Potion> getPotion(ItemStack itemStack) {
        return ((PotionContents)itemStack.get(DataComponents.POTION_CONTENTS)).potion().orElse(Potions.WATER);
    }

    protected static void addRecipeIfNew(IPrototypedIngredient<ItemStack, Integer> ingredient, IPrototypedIngredient<ItemStack, Integer> item, ItemStack output, List<ItemStack> newItems) {
        RecipeDefinition recipe = RecipeDefinition.ofIngredients(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new IPrototypedIngredient[]{ingredient}), Lists.newArrayList((Object[])new IPrototypedIngredient[]{item}), Lists.newArrayList((Object[])new IPrototypedIngredient[]{item}), Lists.newArrayList((Object[])new IPrototypedIngredient[]{item})}), MixedIngredients.ofInstances(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{ItemStack.EMPTY, output, output, output})));
        if (!VANILLA_RECIPES.contains(recipe)) {
            VANILLA_RECIPES.add(recipe);
            newItems.add(output);
        }
    }
}

