/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.ingredient.storage;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.capability.ICapabilityGetter;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageWrapperHandler;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.ingredient.collection.FilteredIngredientCollectionIterator;

public class IngredientComponentStorageWrapperHandlerEnergyStorage<C>
implements IIngredientComponentStorageWrapperHandler<Long, Boolean, IEnergyStorage, C> {
    private final IngredientComponent<Long, Boolean> ingredientComponent;
    private final BaseCapability<IEnergyStorage, C> capability;

    public IngredientComponentStorageWrapperHandlerEnergyStorage(IngredientComponent<Long, Boolean> ingredientComponent, BaseCapability<IEnergyStorage, C> capability) {
        this.ingredientComponent = Objects.requireNonNull(ingredientComponent);
        this.capability = capability;
    }

    @Override
    public IIngredientComponentStorage<Long, Boolean> wrapComponentStorage(IEnergyStorage storage) {
        return new ComponentStorageWrapper(this.getComponent(), storage);
    }

    @Override
    public IEnergyStorage wrapStorage(IIngredientComponentStorage<Long, Boolean> componentStorage) {
        return new EnergyStorageWrapper(componentStorage);
    }

    @Override
    public Optional<IEnergyStorage> getStorage(ICapabilityGetter<C> capabilityProvider, @Nullable C context) {
        return Optional.ofNullable(capabilityProvider.getCapability(this.capability, context));
    }

    @Override
    public IngredientComponent<Long, Boolean> getComponent() {
        return this.ingredientComponent;
    }

    public static class ComponentStorageWrapper
    implements IIngredientComponentStorage<Long, Boolean> {
        private final IngredientComponent<Long, Boolean> ingredientComponent;
        private final IEnergyStorage storage;

        public ComponentStorageWrapper(IngredientComponent<Long, Boolean> ingredientComponent, IEnergyStorage storage) {
            this.ingredientComponent = ingredientComponent;
            this.storage = storage;
        }

        @Override
        public IngredientComponent<Long, Boolean> getComponent() {
            return this.ingredientComponent;
        }

        @Override
        public Iterator<Long> iterator() {
            return Iterators.forArray((Object[])new Long[]{this.storage.getEnergyStored()});
        }

        @Override
        public Iterator<Long> iterator(@Nonnull Long prototype, Boolean matchFlags) {
            return new FilteredIngredientCollectionIterator(this.iterator(), this.getComponent().getMatcher(), (Object)prototype, (Object)matchFlags);
        }

        @Override
        public long getMaxQuantity() {
            return this.storage.getMaxEnergyStored();
        }

        @Override
        public Long insert(@Nonnull Long ingredient, boolean simulate) {
            return ingredient - (long)this.storage.receiveEnergy(IModHelpers.get().getBaseHelpers().castSafe(ingredient.longValue()), simulate);
        }

        @Override
        public Long extract(@Nonnull Long prototype, Boolean matchFlags, boolean simulate) {
            int extractable;
            if (matchFlags.booleanValue() && (long)(extractable = this.storage.extractEnergy(IModHelpers.get().getBaseHelpers().castSafe(prototype.longValue()), true)) != prototype) {
                return 0L;
            }
            return this.storage.extractEnergy(IModHelpers.get().getBaseHelpers().castSafe(prototype.longValue()), simulate);
        }

        @Override
        public Long extract(long maxQuantity, boolean simulate) {
            return this.storage.extractEnergy(IModHelpers.get().getBaseHelpers().castSafe(maxQuantity), simulate);
        }
    }

    public static class EnergyStorageWrapper
    implements IEnergyStorage {
        private final IIngredientComponentStorage<Long, Boolean> storage;

        public EnergyStorageWrapper(IIngredientComponentStorage<Long, Boolean> storage) {
            this.storage = storage;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return maxReceive - IModHelpers.get().getBaseHelpers().castSafe(this.storage.insert(Long.valueOf(maxReceive), simulate).longValue());
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return IModHelpers.get().getBaseHelpers().castSafe(this.storage.extract(maxExtract, simulate).longValue());
        }

        public int getEnergyStored() {
            long total = 0L;
            for (Long stored : this.storage) {
                total = Math.addExact(total, stored);
            }
            return IModHelpers.get().getBaseHelpers().castSafe(total);
        }

        public int getMaxEnergyStored() {
            return IModHelpers.get().getBaseHelpers().castSafe(this.storage.getMaxQuantity());
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

