/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.itemhandler;

import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.itemhandler.FilteredItemHandlerItemStackIterator;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemMatch;
import org.cyclops.commoncapabilities.api.capability.resourcehandler.ResourceHandlerIngredientIterator;

public class DefaultSlotlessItemHandlerWrapper
implements ISlotlessItemHandler {
    private final ResourceHandler<ItemResource> itemHandler;

    public DefaultSlotlessItemHandlerWrapper(ResourceHandler<ItemResource> itemHandler) {
        this.itemHandler = itemHandler;
    }

    public ResourceHandler<ItemResource> getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public Iterator<ItemStack> getItems() {
        return new ResourceHandlerIngredientIterator<ItemResource, ItemStack>(this.getItemHandler(), IngredientComponents.ITEMSTACK_CONVERTER);
    }

    @Override
    public Iterator<ItemStack> findItems(@Nonnull ItemStack stack, int matchFlags) {
        return new FilteredItemHandlerItemStackIterator(this.getItemHandler(), stack, matchFlags);
    }

    @Override
    @Nonnull
    public ItemStack insertItem(@Nonnull ItemStack stack, TransactionContext transaction) {
        int inserted = this.getItemHandler().insert((Resource)ItemResource.of((ItemStack)stack), stack.getCount(), transaction);
        return inserted > 0 ? stack.copyWithCount(stack.getCount() - inserted) : stack;
    }

    @Override
    @Nonnull
    public ItemStack extractItem(int amount, TransactionContext transaction) {
        ResourceHandler<ItemResource> itemHandler = this.getItemHandler();
        for (int i = 0; i < itemHandler.size(); ++i) {
            int extracted;
            ItemResource resource = (ItemResource)itemHandler.getResource(i);
            if (resource.isEmpty() || (extracted = itemHandler.extract(i, (Resource)resource, amount, transaction)) <= 0) continue;
            return resource.toStack(extracted);
        }
        return ItemStack.EMPTY;
    }

    @Override
    @Nonnull
    public ItemStack extractItem(@Nonnull ItemStack matchStack, int matchFlags, TransactionContext transaction) {
        ResourceHandler<ItemResource> itemHandler = this.getItemHandler();
        for (int i = 0; i < itemHandler.size(); ++i) {
            int amount = matchStack.getCount();
            try (Transaction tx = Transaction.open((TransactionContext)transaction);){
                ItemResource resource = (ItemResource)itemHandler.getResource(i);
                if (resource.isEmpty()) continue;
                int extracted = itemHandler.extract(i, (Resource)resource, amount, (TransactionContext)tx);
                ItemStack itemStack = resource.toStack(extracted);
                if (extracted <= 0 || !ItemMatch.areItemStacksEqual(matchStack, itemStack, matchFlags)) continue;
                tx.commit();
                ItemStack itemStack2 = itemStack;
                return itemStack2;
            }
        }
        return ItemStack.EMPTY;
    }

    @Override
    public int getLimit() {
        int total = 0;
        for (int i = 0; i < this.itemHandler.size(); ++i) {
            total += this.itemHandler.getCapacityAsInt(i, (Resource)ItemResource.EMPTY);
        }
        return total;
    }
}

