/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.itemhandler;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemMatch;

public class FilteredItemHandlerItemStackIterator
implements Iterator<ItemStack> {
    private final ResourceHandler<ItemResource> itemHandler;
    private final ItemStack prototype;
    private final int matchFlags;
    private int slot = 0;
    private ItemStack next;

    public FilteredItemHandlerItemStackIterator(ResourceHandler<ItemResource> itemHandler, ItemStack prototype, int matchFlags) {
        this.itemHandler = itemHandler;
        this.prototype = prototype;
        this.matchFlags = matchFlags;
        this.next = this.findNext();
    }

    protected ItemStack findNext() {
        while (this.slot < this.itemHandler.size()) {
            ItemStack itemStack = ((ItemResource)this.itemHandler.getResource(this.slot)).toStack(this.itemHandler.getAmountAsInt(this.slot++));
            if (!ItemMatch.areItemStacksEqual(itemStack, this.prototype, this.matchFlags)) continue;
            return itemStack;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public ItemStack next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Slot out of bounds");
        }
        ItemStack next = this.next;
        this.next = this.findNext();
        return next;
    }
}

