/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.itemhandler;

import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public interface ISlotlessItemHandler {
    public Iterator<ItemStack> getItems();

    public Iterator<ItemStack> findItems(@Nonnull ItemStack var1, int var2);

    @Nonnull
    public ItemStack insertItem(@Nonnull ItemStack var1, TransactionContext var2);

    @Nonnull
    default public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate) {
        try (Transaction tx = Transaction.openRoot();){
            ItemStack remaining = this.insertItem(stack, (TransactionContext)tx);
            if (!simulate) {
                tx.commit();
            }
            ItemStack itemStack = remaining;
            return itemStack;
        }
    }

    @Nonnull
    public ItemStack extractItem(int var1, TransactionContext var2);

    @Nonnull
    default public ItemStack extractItem(int amount, boolean simulate) {
        try (Transaction tx = Transaction.openRoot();){
            ItemStack extracted = this.extractItem(amount, (TransactionContext)tx);
            if (!simulate) {
                tx.commit();
            }
            ItemStack itemStack = extracted;
            return itemStack;
        }
    }

    @Nonnull
    public ItemStack extractItem(@Nonnull ItemStack var1, int var2, TransactionContext var3);

    @Nonnull
    default public ItemStack extractItem(@Nonnull ItemStack matchStack, int matchFlags, boolean simulate) {
        try (Transaction tx = Transaction.openRoot();){
            ItemStack extracted = this.extractItem(matchStack, matchFlags, (TransactionContext)tx);
            if (!simulate) {
                tx.commit();
            }
            ItemStack itemStack = extracted;
            return itemStack;
        }
    }

    public int getLimit();
}

