/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.itemhandler;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemMatch;
import org.cyclops.commoncapabilities.api.capability.resourcehandler.ResourceHandlerIngredientIterator;

public abstract class SlotlessItemHandlerWrapper
implements ISlotlessItemHandler {
    protected final ResourceHandler<ItemResource> itemHandler;

    public SlotlessItemHandlerWrapper(ResourceHandler<ItemResource> itemHandler) {
        this.itemHandler = itemHandler;
    }

    protected abstract PrimitiveIterator.OfInt getNonFullSlotsWithItemStack(@Nonnull ItemStack var1, int var2);

    protected abstract PrimitiveIterator.OfInt getNonEmptySlotsWithItemStack(@Nonnull ItemStack var1, int var2);

    protected abstract PrimitiveIterator.OfInt getSlotsWithItemStack(@Nonnull ItemStack var1, int var2);

    protected abstract PrimitiveIterator.OfInt getEmptySlots();

    protected abstract PrimitiveIterator.OfInt getNonEmptySlots();

    @Override
    public Iterator<ItemStack> getItems() {
        return new ResourceHandlerIngredientIterator<ItemResource, ItemStack>(this.itemHandler, IngredientComponents.ITEMSTACK_CONVERTER);
    }

    @Override
    public Iterator<ItemStack> findItems(@Nonnull ItemStack stack, int matchFlags) {
        return Iterators.transform((Iterator)this.getSlotsWithItemStack(stack, matchFlags), input -> ((ItemResource)this.itemHandler.getResource(input.intValue())).toStack(this.itemHandler.getAmountAsInt(input.intValue())));
    }

    @Override
    @Nonnull
    public ItemStack insertItem(@Nonnull ItemStack stack, TransactionContext transaction) {
        int toInsert;
        int inserted;
        PrimitiveIterator.OfInt itNonFull = this.getNonFullSlotsWithItemStack(stack, 5);
        ItemResource resource = ItemResource.of((ItemStack)stack);
        for (toInsert = stack.getCount(); itNonFull.hasNext() && toInsert > 0; toInsert -= inserted) {
            int slot = itNonFull.nextInt();
            inserted = this.itemHandler.insert(slot, (Resource)resource, toInsert, transaction);
        }
        PrimitiveIterator.OfInt itEmpty = this.getEmptySlots();
        while (itEmpty.hasNext() && toInsert > 0) {
            int slot = itEmpty.nextInt();
            int inserted2 = this.itemHandler.insert(slot, (Resource)resource, toInsert, transaction);
            toInsert -= inserted2;
        }
        return toInsert == 0 ? ItemStack.EMPTY : stack.copyWithCount(toInsert);
    }

    @Override
    @Nonnull
    public ItemStack extractItem(int amount, TransactionContext transaction) {
        PrimitiveIterator.OfInt it = this.getNonEmptySlots();
        ItemStack extractedAcc = ItemStack.EMPTY;
        while (it.hasNext() && amount > 0) {
            int slot = it.nextInt();
            ItemResource slotResource = (ItemResource)this.itemHandler.getResource(slot);
            if (!extractedAcc.isEmpty() && !slotResource.matches(extractedAcc)) continue;
            Transaction tx = Transaction.open((TransactionContext)transaction);
            try {
                int extracted = this.itemHandler.extract(slot, (Resource)slotResource, amount, (TransactionContext)tx);
                if (extracted <= 0) continue;
                tx.commit();
                if (extractedAcc.isEmpty()) {
                    extractedAcc = slotResource.toStack(extracted);
                } else {
                    extractedAcc.grow(extracted);
                }
                amount -= extracted;
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
        return extractedAcc;
    }

    @Override
    @Nonnull
    public ItemStack extractItem(@Nonnull ItemStack matchStack, int matchFlags, TransactionContext transaction) {
        PrimitiveIterator.OfInt itSimulated = this.getNonEmptySlotsWithItemStack(matchStack, matchFlags);
        int amount = matchStack.getCount();
        ItemStack extractedAcc = ItemStack.EMPTY;
        while (itSimulated.hasNext() && amount > 0) {
            int slot = itSimulated.nextInt();
            ItemResource slotResource = (ItemResource)this.itemHandler.getResource(slot);
            if (!extractedAcc.isEmpty() && !slotResource.matches(extractedAcc)) continue;
            Transaction tx = Transaction.open((TransactionContext)transaction);
            try {
                ItemStack extractedStack;
                int extracted = this.itemHandler.extract(slot, (Resource)slotResource, amount, (TransactionContext)tx);
                if (extracted <= 0 || !ItemMatch.areItemStacksEqual(extractedStack = matchStack.copyWithCount(extracted), matchStack, matchFlags & 0xFFFFFFF7)) continue;
                tx.commit();
                if (extractedAcc.isEmpty()) {
                    extractedAcc = slotResource.toStack(extracted);
                } else {
                    extractedAcc.grow(extracted);
                }
                amount -= extracted;
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
        return extractedAcc;
    }

    @Override
    public int getLimit() {
        int total = 0;
        for (int i = 0; i < this.itemHandler.size(); ++i) {
            total += this.itemHandler.getCapacityAsInt(i, (Resource)((ItemResource)this.itemHandler.getResource(i)));
        }
        return total;
    }
}

