/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.resourcehandler;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.resource.Resource;
import org.cyclops.commoncapabilities.api.ingredient.IResourceConverter;

public class ResourceHandlerIngredientIterator<R extends Resource, T>
implements Iterator<T> {
    private final ResourceHandler<R> resourceHandler;
    private final IResourceConverter<R, T> resourceConverter;
    private final int maxSlots;
    private int slot;

    public ResourceHandlerIngredientIterator(ResourceHandler<R> resourceHandler, IResourceConverter<R, T> resourceConverter, int offset) {
        this.resourceHandler = resourceHandler;
        this.resourceConverter = resourceConverter;
        this.maxSlots = resourceHandler.size();
        this.slot = offset;
    }

    public ResourceHandlerIngredientIterator(ResourceHandler<R> resourceHandler, IResourceConverter<R, T> resourceConverter) {
        this(resourceHandler, resourceConverter, 0);
    }

    @Override
    public boolean hasNext() {
        return this.slot < this.maxSlots;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Slot out of bounds");
        }
        return this.resourceConverter.fromResource(this.resourceHandler.getResource(this.slot), this.resourceHandler.getAmountAsInt(this.slot++));
    }
}

