/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.ingredient;

import net.minecraft.core.Holder;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;

public interface IPrototypedIngredient<T, M>
extends Comparable<IPrototypedIngredient<?, ?>> {
    public IngredientComponent<T, M> getComponent();

    public T getPrototype();

    public M getCondition();

    public static <T, M> void serialize(ValueOutput valueOutput, IPrototypedIngredient<T, M> prototypedIngredient) {
        IngredientComponent<T, M> component = prototypedIngredient.getComponent();
        valueOutput.putString("ingredientComponent", component.getName().toString());
        IIngredientSerializer<T, M> serializer = component.getSerializer();
        serializer.serializeInstance(valueOutput.child("prototype"), prototypedIngredient.getPrototype());
        valueOutput.store("condition", ExtraCodecs.NBT, (Object)serializer.serializeCondition(prototypedIngredient.getCondition()));
    }

    public static PrototypedIngredient deserialize(ValueInput valueInput) throws IllegalArgumentException {
        String componentName = (String)valueInput.getString("ingredientComponent").orElseThrow(() -> new IllegalArgumentException("Could not find a ingredientComponent entry in the given tag"));
        IngredientComponent component = (IngredientComponent)((Holder.Reference)IngredientComponent.REGISTRY.get(ResourceLocation.parse((String)componentName)).orElseThrow(() -> new IllegalArgumentException("Could not find the ingredient component type " + componentName))).value();
        IIngredientSerializer serializer = component.getSerializer();
        Object prototype = serializer.deserializeInstance((ValueInput)valueInput.child("prototype").orElseThrow());
        Object condition = serializer.deserializeCondition((Tag)valueInput.read("condition", ExtraCodecs.NBT).orElseThrow());
        return new PrototypedIngredient(component, prototype, condition);
    }
}

