/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.ingredient.storage;

import java.util.Iterator;
import javax.annotation.Nonnull;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;

public interface IIngredientComponentStorage<T, M>
extends Iterable<T> {
    public IngredientComponent<T, M> getComponent();

    @Override
    public Iterator<T> iterator();

    public Iterator<T> iterator(@Nonnull T var1, M var2);

    public long getMaxQuantity();

    public T insert(@Nonnull T var1, TransactionContext var2);

    default public T insert(@Nonnull T ingredient, boolean simulate) {
        try (Transaction tx = Transaction.openRoot();){
            T inserted = this.insert(ingredient, (TransactionContext)tx);
            if (!simulate) {
                tx.commit();
            }
            T t = inserted;
            return t;
        }
    }

    public T extract(@Nonnull T var1, M var2, TransactionContext var3);

    default public T extract(@Nonnull T prototype, M matchCondition, boolean simulate) {
        try (Transaction tx = Transaction.openRoot();){
            T extracted = this.extract(prototype, matchCondition, (TransactionContext)tx);
            if (!simulate) {
                tx.commit();
            }
            T t = extracted;
            return t;
        }
    }

    public T extract(long var1, TransactionContext var3);

    default public T extract(long maxQuantity, boolean simulate) {
        try (Transaction tx = Transaction.openRoot();){
            T extracted = this.extract(maxQuantity, (TransactionContext)tx);
            if (!simulate) {
                tx.commit();
            }
            T t = extracted;
            return t;
        }
    }
}

