/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.capability.itemhandler;

import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public abstract class ItemItemHandler
implements ResourceHandler<ItemResource> {
    private final ItemStack itemStack;
    private final SnapshotJournal<NonNullList<ItemStack>> snapshotJournal;

    public ItemItemHandler(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.snapshotJournal = new SnapshotJournal<NonNullList<ItemStack>>(){

            protected NonNullList<ItemStack> createSnapshot() {
                return NonNullList.copyOf(ItemItemHandler.this.getItemList());
            }

            protected void revertToSnapshot(NonNullList<ItemStack> snapshot) {
                ItemItemHandler.this.setItemList(snapshot);
            }
        };
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    protected abstract NonNullList<ItemStack> getItemList();

    protected abstract void setItemList(NonNullList<ItemStack> var1);

    public void setStackInSlot(int slot, ItemStack stack) {
        NonNullList<ItemStack> itemStacks = this.getItemList();
        itemStacks.set(slot, (Object)stack);
        this.setItemList(itemStacks);
    }

    @Nonnull
    public ItemResource getResource(int slot) {
        return ItemResource.of((ItemStack)((ItemStack)this.getItemList().get(slot)));
    }

    public long getAmountAsLong(int slot) {
        return ((ItemStack)this.getItemList().get(slot)).getCount();
    }

    @Nonnull
    public int insert(int slot, ItemResource itemResource, int amount, TransactionContext transaction) {
        if (itemResource.isEmpty()) {
            return 0;
        }
        NonNullList<ItemStack> itemStacks = this.getItemList();
        ItemStack existingStack = (ItemStack)itemStacks.get(slot);
        this.snapshotJournal.updateSnapshots(transaction);
        if (!existingStack.isEmpty()) {
            if (!itemResource.matches(existingStack)) {
                return 0;
            }
            int maxStackSize = Math.min(itemResource.getMaxStackSize(), this.getCapacityAsInt(slot, (Resource)itemResource)) - existingStack.getCount();
            if (amount <= maxStackSize) {
                this.setStackInSlot(slot, itemResource.toStack(existingStack.getCount() + amount));
                return amount;
            }
            this.setStackInSlot(slot, itemResource.toStack(maxStackSize));
            return maxStackSize - existingStack.getCount();
        }
        int maxStackSize = Math.min(itemResource.getMaxStackSize(), this.getCapacityAsInt(slot, (Resource)itemResource));
        if (maxStackSize < amount) {
            this.setStackInSlot(slot, itemResource.toStack(maxStackSize));
            return maxStackSize - amount;
        }
        this.setStackInSlot(slot, itemResource.toStack(amount));
        return amount;
    }

    @Nonnull
    public int extract(int slot, ItemResource itemResource, int amount, TransactionContext transaction) {
        if (amount == 0) {
            return 0;
        }
        ItemStack existingStack = this.getResource(slot).toStack(this.getAmountAsInt(slot));
        if (existingStack.isEmpty()) {
            return 0;
        }
        ItemStack extracted = existingStack.split(amount);
        this.snapshotJournal.updateSnapshots(transaction);
        this.setStackInSlot(slot, existingStack);
        return extracted.getCount();
    }
}

