/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.gametest.GameTest;

public class GameTestsVanillaCapabilitiesEntityItem {
    public static final String TEMPLATE_EMPTY = "commoncapabilities:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 1, 2);

    @GameTest(template="commoncapabilities:empty10")
    public void testEntityItemCapItemShulkerboxAdd(GameTestHelper helper) {
        int inserted;
        ItemEntity entity = helper.spawnItem(Items.SHULKER_BOX, POS);
        ResourceHandler itemHandler = (ResourceHandler)entity.getCapability(Capabilities.Item.ENTITY);
        try (Transaction tx = Transaction.openRoot();){
            inserted = itemHandler.insert((Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            tx.commit();
        }
        helper.succeedIf(() -> {
            helper.assertTrue(inserted == 1, (Component)Component.literal((String)"Remaining of insertion is not empty"));
            helper.assertTrue(((ItemResource)itemHandler.getResource(0)).getItem() == Items.APPLE, (Component)Component.literal((String)"Item was not added"));
        });
    }

    @GameTest(template="commoncapabilities:empty10")
    public void testEntityItemCapItemShulkerboxRemove(GameTestHelper helper) {
        int removed;
        ItemEntity entity = helper.spawnItem(Items.SHULKER_BOX, POS);
        ResourceHandler itemHandler = (ResourceHandler)entity.getCapability(Capabilities.Item.ENTITY);
        try (Transaction tx = Transaction.openRoot();){
            itemHandler.insert((Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            removed = itemHandler.extract((Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            tx.commit();
        }
        helper.succeedIf(() -> {
            helper.assertTrue(removed == 1, (Component)Component.literal((String)"Removed item is empty"));
            helper.assertTrue(((ItemResource)itemHandler.getResource(0)).isEmpty(), (Component)Component.literal((String)"Item was not removed"));
        });
    }

    @GameTest(template="commoncapabilities:empty10")
    public void testEntityItemCapFluidBucketAdd(GameTestHelper helper) {
        int filled;
        ItemEntity entity = helper.spawnItem(Items.BUCKET, POS);
        ResourceHandler fluidHandler = (ResourceHandler)entity.getCapability(Capabilities.Fluid.ENTITY, (Object)Direction.UP);
        try (Transaction tx = Transaction.openRoot();){
            filled = fluidHandler.insert((Resource)FluidResource.of((Fluid)Fluids.WATER), 1000, (TransactionContext)tx);
            tx.commit();
        }
        helper.succeedIf(() -> {
            helper.assertTrue(filled == 1000, (Component)Component.literal((String)"Insertion was not 1000"));
            helper.assertTrue(fluidHandler.getAmountAsInt(0) == 1000, (Component)Component.literal((String)"Fluid was not added"));
        });
    }

    @GameTest(template="commoncapabilities:empty10")
    public void testEntityItemCapFluidBucketRemove(GameTestHelper helper) {
        int drained;
        ItemEntity entity = helper.spawnItem(Items.WATER_BUCKET, POS);
        ResourceHandler fluidHandler = (ResourceHandler)entity.getCapability(Capabilities.Fluid.ENTITY, (Object)Direction.UP);
        try (Transaction tx = Transaction.openRoot();){
            fluidHandler.insert((Resource)FluidResource.of((Fluid)Fluids.WATER), 1000, (TransactionContext)tx);
            drained = fluidHandler.extract((Resource)FluidResource.of((Fluid)Fluids.WATER), 1000, (TransactionContext)tx);
            tx.commit();
        }
        helper.succeedIf(() -> {
            helper.assertTrue(drained == 1000, (Component)Component.literal((String)"Removal was not 1000"));
            helper.assertTrue(((FluidResource)fluidHandler.getResource(0)).isEmpty(), (Component)Component.literal((String)"Fluid was not removed"));
        });
    }
}

