/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.gametest.GameTest;

public class GameTestsVanillaCapabilitiesEntityItemFrame {
    public static final String TEMPLATE_EMPTY = "commoncapabilities:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 1, 2);

    @GameTest(template="commoncapabilities:empty10")
    public void testEntityItemFrameAdd(GameTestHelper helper) {
        int inserted;
        ItemFrame entity = (ItemFrame)helper.spawn(EntityType.ITEM_FRAME, POS);
        entity.setItem(new ItemStack((ItemLike)Items.SHULKER_BOX));
        ResourceHandler itemHandler = (ResourceHandler)entity.getCapability(Capabilities.Item.ENTITY);
        try (Transaction tx = Transaction.openRoot();){
            inserted = itemHandler.insert((Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            tx.commit();
        }
        helper.succeedIf(() -> {
            helper.assertTrue(inserted == 1, (Component)Component.literal((String)"Remaining of insertion is not empty"));
            helper.assertTrue(((ItemResource)itemHandler.getResource(0)).getItem() == Items.APPLE, (Component)Component.literal((String)"Item was not added"));
        });
    }

    @GameTest(template="commoncapabilities:empty10")
    public void testEntityItemFrameRemove(GameTestHelper helper) {
        int removed;
        ItemFrame entity = (ItemFrame)helper.spawn(EntityType.ITEM_FRAME, POS);
        entity.setItem(new ItemStack((ItemLike)Items.SHULKER_BOX));
        ResourceHandler itemHandler = (ResourceHandler)entity.getCapability(Capabilities.Item.ENTITY);
        try (Transaction tx = Transaction.openRoot();){
            itemHandler.insert((Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            removed = itemHandler.extract((Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            tx.commit();
        }
        helper.succeedIf(() -> {
            helper.assertTrue(removed == 1, (Component)Component.literal((String)"Removed item is empty"));
            helper.assertTrue(((ItemResource)itemHandler.getResource(0)).isEmpty(), (Component)Component.literal((String)"Item was not removed"));
        });
    }
}

