/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.gametest.GameTest;

public class GameTestsVanillaCapabilitiesItemItemHandler {
    public static final String TEMPLATE_EMPTY = "commoncapabilities:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 1, 2);

    @GameTest(template="commoncapabilities:empty10")
    public void testItemItemHandlerCapItemShulkerboxAdd(GameTestHelper helper) {
        int inserted;
        ItemStack itemStack = new ItemStack((ItemLike)Items.SHULKER_BOX);
        ResourceHandler itemHandler = (ResourceHandler)itemStack.getCapability(Capabilities.Item.ITEM, (Object)ItemAccess.forStack((ItemStack)itemStack));
        try (Transaction tx = Transaction.openRoot();){
            inserted = itemHandler.insert((Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            tx.commit();
        }
        helper.succeedIf(() -> {
            helper.assertTrue(inserted == 1, (Component)Component.literal((String)"Remaining of insertion is not empty"));
            helper.assertTrue(((ItemResource)itemHandler.getResource(0)).getItem() == Items.APPLE, (Component)Component.literal((String)"Item was not added"));
        });
    }

    @GameTest(template="commoncapabilities:empty10")
    public void testEntityItemCapItemShulkerboxRemove(GameTestHelper helper) {
        int removed;
        ItemStack itemStack = new ItemStack((ItemLike)Items.SHULKER_BOX);
        ResourceHandler itemHandler = (ResourceHandler)itemStack.getCapability(Capabilities.Item.ITEM, (Object)ItemAccess.forStack((ItemStack)itemStack));
        try (Transaction tx = Transaction.openRoot();){
            itemHandler.insert((Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            removed = itemHandler.extract((Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            tx.commit();
        }
        helper.succeedIf(() -> {
            helper.assertTrue(removed == 1, (Component)Component.literal((String)"Removed item is empty"));
            helper.assertTrue(((ItemResource)itemHandler.getResource(0)).isEmpty(), (Component)Component.literal((String)"Item was not removed"));
        });
    }

    @GameTest(template="commoncapabilities:empty10")
    public void testItemItemHandlerCapItemBundleAdd(GameTestHelper helper) {
        int inserted;
        ItemStack itemStack = new ItemStack((ItemLike)Items.BUNDLE);
        ResourceHandler itemHandler = (ResourceHandler)itemStack.getCapability(Capabilities.Item.ITEM, (Object)ItemAccess.forStack((ItemStack)itemStack));
        try (Transaction tx = Transaction.openRoot();){
            inserted = itemHandler.insert((Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            tx.commit();
        }
        helper.succeedIf(() -> {
            helper.assertTrue(inserted == 1, (Component)Component.literal((String)"Remaining of insertion is not empty"));
            helper.assertTrue(((ItemResource)itemHandler.getResource(0)).getItem() == Items.APPLE, (Component)Component.literal((String)"Item was not added"));
        });
    }

    @GameTest(template="commoncapabilities:empty10")
    public void testEntityItemCapItemBundleRemove(GameTestHelper helper) {
        int removed;
        ItemStack itemStack = new ItemStack((ItemLike)Items.BUNDLE);
        ResourceHandler itemHandler = (ResourceHandler)itemStack.getCapability(Capabilities.Item.ITEM, (Object)ItemAccess.forStack((ItemStack)itemStack));
        try (Transaction tx = Transaction.openRoot();){
            itemHandler.insert((Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            removed = itemHandler.extract((Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            tx.commit();
        }
        helper.succeedIf(() -> {
            helper.assertTrue(removed == 1, (Component)Component.literal((String)"Removed item is empty"));
            helper.assertTrue(((ItemResource)itemHandler.getResource(0)).isEmpty(), (Component)Component.literal((String)"Item was not removed"));
        });
    }

    @GameTest(template="commoncapabilities:empty10")
    public void testItemItemHandlerCapItemBundleAddMultiple(GameTestHelper helper) {
        int inserted4;
        int inserted3;
        int inserted2;
        int inserted1;
        ItemStack itemStack = new ItemStack((ItemLike)Items.BUNDLE);
        ResourceHandler itemHandler = (ResourceHandler)itemStack.getCapability(Capabilities.Item.ITEM, (Object)ItemAccess.forStack((ItemStack)itemStack));
        try (Transaction tx = Transaction.openRoot();){
            inserted1 = itemHandler.insert(0, (Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            inserted2 = itemHandler.insert(0, (Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            inserted3 = itemHandler.insert(1, (Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            inserted4 = itemHandler.insert(1, (Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            tx.commit();
        }
        helper.succeedIf(() -> {
            helper.assertTrue(inserted1 == 1, (Component)Component.literal((String)"Remaining of insertion 1 is not empty"));
            helper.assertTrue(inserted2 == 1, (Component)Component.literal((String)"Remaining of insertion 2 is not empty"));
            helper.assertTrue(inserted3 == 1, (Component)Component.literal((String)"Remaining of insertion 3 is not empty"));
            helper.assertTrue(inserted4 == 1, (Component)Component.literal((String)"Remaining of insertion 4 is not empty"));
            helper.assertTrue(itemHandler.size() == 3, (Component)Component.literal((String)"Slot count was not 3"));
            helper.assertTrue(((ItemResource)itemHandler.getResource(0)).getItem() == Items.APPLE, (Component)Component.literal((String)"Item was not added"));
            helper.assertTrue(itemHandler.getAmountAsInt(0) == 2, (Component)Component.literal((String)"Item count was not 2 in slot 0"));
            helper.assertTrue(((ItemResource)itemHandler.getResource(1)).getItem() == Items.APPLE, (Component)Component.literal((String)"Item was not added"));
            helper.assertTrue(itemHandler.getAmountAsInt(1) == 2, (Component)Component.literal((String)"Item count was not 2 in slot 1"));
        });
    }

    @GameTest(template="commoncapabilities:empty10")
    public void testEntityItemCapItemBundleRemoveMultiple(GameTestHelper helper) {
        int removed3;
        int removed2;
        int removed1;
        ItemStack itemStack = new ItemStack((ItemLike)Items.BUNDLE);
        ResourceHandler itemHandler = (ResourceHandler)itemStack.getCapability(Capabilities.Item.ITEM, (Object)ItemAccess.forStack((ItemStack)itemStack));
        try (Transaction tx = Transaction.openRoot();){
            itemHandler.insert(0, (Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            itemHandler.insert(0, (Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            itemHandler.insert(1, (Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            itemHandler.insert(1, (Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            removed1 = itemHandler.extract(1, (Resource)ItemResource.of((ItemLike)Items.APPLE), 2, (TransactionContext)tx);
            removed2 = itemHandler.extract(0, (Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            removed3 = itemHandler.extract(0, (Resource)ItemResource.of((ItemLike)Items.APPLE), 1, (TransactionContext)tx);
            tx.commit();
        }
        helper.succeedIf(() -> {
            helper.assertTrue(removed1 == 2, (Component)Component.literal((String)"Removed item 3 is not 2"));
            helper.assertTrue(removed2 == 1, (Component)Component.literal((String)"Removed item 1 is empty"));
            helper.assertTrue(removed3 == 1, (Component)Component.literal((String)"Removed item 2 is empty"));
            helper.assertTrue(itemHandler.size() == 1, (Component)Component.literal((String)"Slot count was not 1"));
            helper.assertTrue(((ItemResource)itemHandler.getResource(0)).isEmpty(), (Component)Component.literal((String)"Item was not removed in slot 0"));
        });
    }
}

