/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.ingredient.storage;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.capability.ICapabilityGetter;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageWrapperHandler;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.ingredient.collection.FilteredIngredientCollectionIterator;

public class IngredientComponentStorageWrapperHandlerEnergyHandler<C>
implements IIngredientComponentStorageWrapperHandler<Long, Boolean, EnergyHandler, C> {
    private final IngredientComponent<Long, Boolean> ingredientComponent;
    private final BaseCapability<EnergyHandler, C> capability;

    public IngredientComponentStorageWrapperHandlerEnergyHandler(IngredientComponent<Long, Boolean> ingredientComponent, BaseCapability<EnergyHandler, C> capability) {
        this.ingredientComponent = Objects.requireNonNull(ingredientComponent);
        this.capability = capability;
    }

    @Override
    public IIngredientComponentStorage<Long, Boolean> wrapComponentStorage(EnergyHandler storage) {
        return new ComponentStorageWrapper(this.getComponent(), storage);
    }

    @Override
    public EnergyHandler wrapStorage(IIngredientComponentStorage<Long, Boolean> componentStorage) {
        return new EnergyStorageWrapper(componentStorage);
    }

    @Override
    public Optional<EnergyHandler> getStorage(ICapabilityGetter<C> capabilityProvider, @Nullable C context) {
        return Optional.ofNullable(capabilityProvider.getCapability(this.capability, context));
    }

    @Override
    public IngredientComponent<Long, Boolean> getComponent() {
        return this.ingredientComponent;
    }

    public static class ComponentStorageWrapper
    implements IIngredientComponentStorage<Long, Boolean> {
        private final IngredientComponent<Long, Boolean> ingredientComponent;
        private final EnergyHandler storage;

        public ComponentStorageWrapper(IngredientComponent<Long, Boolean> ingredientComponent, EnergyHandler storage) {
            this.ingredientComponent = ingredientComponent;
            this.storage = storage;
        }

        @Override
        public IngredientComponent<Long, Boolean> getComponent() {
            return this.ingredientComponent;
        }

        @Override
        public Iterator<Long> iterator() {
            return Iterators.forArray((Object[])new Long[]{this.storage.getAmountAsLong()});
        }

        @Override
        public Iterator<Long> iterator(@Nonnull Long prototype, Boolean matchFlags) {
            return new FilteredIngredientCollectionIterator(this.iterator(), this.getComponent().getMatcher(), (Object)prototype, (Object)matchFlags);
        }

        @Override
        public long getMaxQuantity() {
            return this.storage.getCapacityAsLong();
        }

        @Override
        public Long insert(@Nonnull Long ingredient, TransactionContext transactionContext) {
            return ingredient - (long)this.storage.insert(IModHelpers.get().getBaseHelpers().castSafe(ingredient.longValue()), transactionContext);
        }

        @Override
        public Long extract(@Nonnull Long prototype, Boolean matchFlags, TransactionContext transactionContext) {
            if (matchFlags.booleanValue()) {
                try (Transaction tx = Transaction.open((TransactionContext)transactionContext);){
                    int extractable = this.storage.extract(IModHelpers.get().getBaseHelpers().castSafe(prototype.longValue()), (TransactionContext)tx);
                    if ((long)extractable != prototype) {
                        Long l = 0L;
                        return l;
                    }
                }
            }
            return this.storage.extract(IModHelpers.get().getBaseHelpers().castSafe(prototype.longValue()), transactionContext);
        }

        @Override
        public Long extract(long maxQuantity, TransactionContext transactionContext) {
            return this.storage.extract(IModHelpers.get().getBaseHelpers().castSafe(maxQuantity), transactionContext);
        }
    }

    public static class EnergyStorageWrapper
    implements EnergyHandler {
        private final IIngredientComponentStorage<Long, Boolean> storage;

        public EnergyStorageWrapper(IIngredientComponentStorage<Long, Boolean> storage) {
            this.storage = storage;
        }

        public long getAmountAsLong() {
            long total = 0L;
            for (Long stored : this.storage) {
                total = Math.addExact(total, stored);
            }
            return IModHelpers.get().getBaseHelpers().castSafe(total);
        }

        public long getCapacityAsLong() {
            return this.storage.getMaxQuantity();
        }

        public int insert(int max, TransactionContext transactionContext) {
            return max - IModHelpers.get().getBaseHelpers().castSafe(this.storage.insert(Long.valueOf(max), transactionContext).longValue());
        }

        public int extract(int max, TransactionContext transactionContext) {
            return IModHelpers.get().getBaseHelpers().castSafe(this.storage.extract((long)max, transactionContext).longValue());
        }
    }
}

