/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.ingredient.storage;

import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.commoncapabilities.api.ingredient.IResourceConverter;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.capability.ICapabilityGetter;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IngredientComponentStorageEmpty;
import org.cyclops.commoncapabilities.ingredient.storage.IngredientComponentStorageWrapperHandlerResourceHandler;
import org.cyclops.cyclopscore.helper.IModHelpers;

public class IngredientComponentStorageWrapperHandlerItemStack<C>
extends IngredientComponentStorageWrapperHandlerResourceHandler<C, ItemResource, ItemStack, Integer> {
    private final BaseCapability<ISlotlessItemHandler, C> capabilitySlotless;

    public IngredientComponentStorageWrapperHandlerItemStack(IngredientComponent<ItemStack, Integer> ingredientComponent, BaseCapability<ResourceHandler<ItemResource>, C> capability, BaseCapability<ISlotlessItemHandler, C> capabilitySlotless) {
        super(ingredientComponent, capability, IngredientComponents.ITEMSTACK_CONVERTER);
        this.capabilitySlotless = capabilitySlotless;
    }

    public IIngredientComponentStorage<ItemStack, Integer> wrapComponentStorage(ResourceHandler<ItemResource> storage, ISlotlessItemHandler slotlessStorage) {
        return new ComponentStorageWrapperCombined(this.getComponent(), storage, this.resourceConverter, slotlessStorage);
    }

    @Override
    public IIngredientComponentStorage<ItemStack, Integer> getComponentStorage(ICapabilityGetter<C> capabilityProvider, @Nullable C context) {
        Optional storageSlotted = this.getStorage(capabilityProvider, context);
        Optional<ISlotlessItemHandler> storageSlotless = Optional.ofNullable(capabilityProvider.getCapability(this.capabilitySlotless, context));
        if (storageSlotted.isPresent()) {
            if (storageSlotless.isPresent()) {
                return this.wrapComponentStorage((ResourceHandler<ItemResource>)((ResourceHandler)storageSlotted.orElse(null)), storageSlotless.orElse(null));
            }
            return this.wrapComponentStorage(storageSlotted.orElse(null));
        }
        return new IngredientComponentStorageEmpty<ItemStack, Integer>(this.getComponent());
    }

    public static class ComponentStorageWrapperCombined
    extends IngredientComponentStorageWrapperHandlerResourceHandler.ComponentStorageWrapper<ItemResource, ItemStack, Integer> {
        private final ISlotlessItemHandler storageSlotless;

        public ComponentStorageWrapperCombined(IngredientComponent<ItemStack, Integer> ingredientComponent, ResourceHandler<ItemResource> storage, IResourceConverter<ItemResource, ItemStack> resourceConverter, ISlotlessItemHandler storageSlotless) {
            super(ingredientComponent, storage, resourceConverter);
            this.storageSlotless = storageSlotless;
        }

        @Override
        public Iterator<ItemStack> iterator() {
            return this.storageSlotless.getItems();
        }

        @Override
        public Iterator<ItemStack> iterator(@Nonnull ItemStack prototype, Integer matchFlags) {
            return this.storageSlotless.findItems(prototype, matchFlags);
        }

        @Override
        public long getMaxQuantity() {
            return this.storageSlotless.getLimit();
        }

        @Override
        public ItemStack insert(@Nonnull ItemStack ingredient, TransactionContext transaction) {
            return this.storageSlotless.insertItem(ingredient, transaction);
        }

        @Override
        public ItemStack extract(long maxQuantity, TransactionContext transaction) {
            return this.storageSlotless.extractItem(IModHelpers.get().getBaseHelpers().castSafe(maxQuantity), transaction);
        }

        @Override
        public ItemStack extract(@Nonnull ItemStack prototype, Integer matchFlags, TransactionContext transaction) {
            return this.storageSlotless.extractItem(prototype, (int)matchFlags, transaction);
        }
    }
}

