/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.ingredient.storage;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.capability.resourcehandler.ResourceHandlerIngredientIterator;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IResourceConverter;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.capability.ICapabilityGetter;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageSlotted;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageWrapperHandler;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.ingredient.collection.FilteredIngredientCollectionIterator;
import org.cyclops.cyclopscore.ingredient.collection.IngredientHashMap;

public class IngredientComponentStorageWrapperHandlerResourceHandler<C, R extends Resource, T, M>
implements IIngredientComponentStorageWrapperHandler<T, M, ResourceHandler<R>, C> {
    private final IngredientComponent<T, M> ingredientComponent;
    private final BaseCapability<? extends ResourceHandler<R>, C> capability;
    protected final IResourceConverter<R, T> resourceConverter;

    public IngredientComponentStorageWrapperHandlerResourceHandler(IngredientComponent<T, M> ingredientComponent, BaseCapability<? extends ResourceHandler<R>, C> capability, IResourceConverter<R, T> resourceConverter) {
        this.ingredientComponent = ingredientComponent;
        this.capability = capability;
        this.resourceConverter = resourceConverter;
    }

    @Override
    public IIngredientComponentStorage<T, M> wrapComponentStorage(ResourceHandler<R> storage) {
        return new ComponentStorageWrapper<R, T, M>(this.getComponent(), storage, this.resourceConverter);
    }

    @Override
    public ResourceHandler<R> wrapStorage(IIngredientComponentStorage<T, M> componentStorage) {
        if (componentStorage instanceof IIngredientComponentStorageSlotted) {
            return new ResourceStorageWrapperSlotted((IIngredientComponentStorageSlotted)componentStorage, this.resourceConverter);
        }
        return new ResourceStorageWrapper<R, T, M>(componentStorage, this.resourceConverter);
    }

    @Override
    public Optional<ResourceHandler<R>> getStorage(ICapabilityGetter<C> capabilityProvider, @Nullable C context) {
        return Optional.ofNullable(capabilityProvider.getCapability(this.capability, context));
    }

    @Override
    public IngredientComponent<T, M> getComponent() {
        return this.ingredientComponent;
    }

    public static class ComponentStorageWrapper<R extends Resource, T, M>
    implements IIngredientComponentStorageSlotted<T, M> {
        private final IngredientComponent<T, M> ingredientComponent;
        private final ResourceHandler<R> storage;
        private final IResourceConverter<R, T> resourceConverter;

        public ComponentStorageWrapper(IngredientComponent<T, M> ingredientComponent, ResourceHandler<R> storage, IResourceConverter<R, T> resourceConverter) {
            this.ingredientComponent = ingredientComponent;
            this.storage = storage;
            this.resourceConverter = resourceConverter;
        }

        @Override
        public IngredientComponent<T, M> getComponent() {
            return this.ingredientComponent;
        }

        @Override
        public Iterator<T> iterator() {
            return new ResourceHandlerIngredientIterator<R, T>(this.storage, this.resourceConverter);
        }

        @Override
        public Iterator<T> iterator(@Nonnull T prototype, M matchFlags) {
            if (this.getComponent().getMatcher().getAnyMatchCondition().equals(matchFlags)) {
                return this.iterator();
            }
            return new FilteredIngredientCollectionIterator(this.iterator(), this.getComponent().getMatcher(), prototype, matchFlags);
        }

        @Override
        public long getMaxQuantity() {
            long sum = 0L;
            R emptyResource = this.resourceConverter.toResource(this.getComponent().getMatcher().getEmptyInstance());
            for (int i = 0; i < this.storage.size(); ++i) {
                sum = Math.addExact(sum, this.storage.getCapacityAsLong(i, emptyResource));
            }
            return sum;
        }

        @Override
        public T insert(@Nonnull T ingredient, TransactionContext transaction) {
            IIngredientMatcher<T, M> matcher = this.ingredientComponent.getMatcher();
            if (matcher.isEmpty(ingredient)) {
                return matcher.getEmptyInstance();
            }
            long totalAmount = matcher.getQuantity(ingredient);
            int filledAmount = this.storage.insert(this.resourceConverter.toResource(ingredient), (int)totalAmount, transaction);
            if ((long)filledAmount >= totalAmount) {
                return matcher.getEmptyInstance();
            }
            long remaining = totalAmount - (long)filledAmount;
            return matcher.withQuantity(ingredient, remaining);
        }

        @Override
        public T extract(@Nonnull T prototype, M matchFlags, TransactionContext transaction) {
            IIngredientMatcher<T, M> matcher = this.ingredientComponent.getMatcher();
            if (matcher.isEmpty(prototype)) {
                return matcher.getEmptyInstance();
            }
            if (matcher.hasCondition(matchFlags, matcher.getQuantityMatchCondition())) {
                IngredientHashMap validInstancesCollapsed = new IngredientHashMap(this.getComponent());
                M matchFlagsNoQuantity = matcher.withoutCondition(matchFlags, matcher.getQuantityMatchCondition());
                int amount = (int)matcher.getQuantity(prototype);
                T finalizeStoragePrototype = null;
                Pair finalizeExistingValue = null;
                try (Transaction tx = Transaction.open((TransactionContext)transaction);){
                    for (int i = 0; i < this.storage.size(); ++i) {
                        Resource contents = this.storage.getResource(i);
                        T contentsInstance = this.resourceConverter.fromResource(contents, this.storage.getAmountAsInt(i));
                        if (contents.isEmpty() || !matcher.matches(contentsInstance, prototype, matchFlagsNoQuantity)) continue;
                        int drained = this.storage.extract(i, contents, amount, (TransactionContext)tx);
                        T drainedInstance = this.resourceConverter.fromResource(contents, drained);
                        T storagePrototype = this.getComponent().getMatcher().withQuantity(drainedInstance, 1L);
                        Pair existingValue = (Pair)validInstancesCollapsed.get(storagePrototype);
                        if (existingValue == null) {
                            existingValue = Pair.of((Object)new Wrapper((Object)0), (Object)Lists.newLinkedList());
                            validInstancesCollapsed.put(storagePrototype, (Object)existingValue);
                        }
                        int newCount = (Integer)((Wrapper)existingValue.getLeft()).get() + drained;
                        ((Wrapper)existingValue.getLeft()).set((Object)newCount);
                        ((List)existingValue.getRight()).add(i);
                        if (newCount < amount) continue;
                        ((Wrapper)existingValue.getLeft()).set((Object)amount);
                        finalizeStoragePrototype = storagePrototype;
                        finalizeExistingValue = existingValue;
                        break;
                    }
                }
                if (finalizeExistingValue != null) {
                    return this.finalizeExtractionForAmount(finalizeStoragePrototype, finalizeExistingValue, amount, transaction);
                }
                return matcher.getEmptyInstance();
            }
            if (matchFlags.equals(matcher.getExactMatchNoQuantityCondition())) {
                int drained = this.storage.extract(this.resourceConverter.toResource(prototype), (int)matcher.getQuantity(prototype), transaction);
                return matcher.withQuantity(prototype, drained);
            }
            int amount = (int)matcher.getQuantity(prototype);
            T extractedAcc = matcher.getEmptyInstance();
            for (int i = 0; i < this.storage.size(); ++i) {
                Resource contents = this.storage.getResource(i);
                T contentsInstance = this.resourceConverter.fromResource(contents, this.storage.getAmountAsInt(i));
                if (contents.isEmpty() || !matcher.isEmpty(extractedAcc) && !matcher.matches(contentsInstance, extractedAcc, matcher.getExactMatchNoQuantityCondition()) || !matcher.matches(contentsInstance, prototype, matchFlags)) continue;
                try (Transaction tx = Transaction.open((TransactionContext)transaction);){
                    int drained = this.storage.extract(i, contents, amount, (TransactionContext)tx);
                    T drainedInstance = this.resourceConverter.fromResource(contents, drained);
                    if (!matcher.matches(drainedInstance, prototype, matchFlags)) continue;
                    tx.commit();
                    extractedAcc = matcher.isEmpty(extractedAcc) ? drainedInstance : matcher.withQuantity(extractedAcc, matcher.getQuantity(extractedAcc) + (long)drained);
                    if ((amount -= drained) > 0) continue;
                    break;
                }
            }
            return extractedAcc;
        }

        protected T finalizeExtractionForAmount(T instancePrototype, Pair<Wrapper<Integer>, List<Integer>> value, int requiredQuantity, TransactionContext transaction) {
            long extractedCount = ((Integer)((Wrapper)value.getLeft()).get()).intValue();
            if (extractedCount > 0L) {
                int toExtract = requiredQuantity;
                for (Integer finalSlot : (List)value.getRight()) {
                    toExtract -= this.storage.extract(finalSlot.intValue(), this.storage.getResource(finalSlot.intValue()), toExtract, transaction);
                }
                if ((long)toExtract != (long)requiredQuantity - extractedCount) {
                    throw new IllegalStateException("An ingredient storage resulted in inconsistent simulated and non-simulated output.");
                }
            }
            return this.getComponent().getMatcher().withQuantity(instancePrototype, extractedCount);
        }

        @Override
        public T extract(long maxQuantity, TransactionContext transaction) {
            IIngredientMatcher<T, M> matcher = this.getComponent().getMatcher();
            return this.extract(matcher.withQuantity(matcher.getNonEmptyInstance(), maxQuantity), matcher.getAnyMatchCondition(), transaction);
        }

        @Override
        public int getSlots() {
            return this.storage.size();
        }

        @Override
        public T getSlotContents(int slot) {
            return this.resourceConverter.fromResource(this.storage.getResource(slot), this.storage.getAmountAsInt(slot));
        }

        @Override
        public long getMaxQuantity(int slot) {
            return this.storage.getCapacityAsLong(slot, this.resourceConverter.toResource(this.getComponent().getMatcher().getEmptyInstance()));
        }

        @Override
        public T insert(int slot, @Nonnull T ingredient, TransactionContext transaction) {
            try (Transaction tx = Transaction.open((TransactionContext)transaction);){
                int totalAmount = IModHelpers.get().getBaseHelpers().castSafe(this.ingredientComponent.getMatcher().getQuantity(ingredient));
                int inserted = this.storage.insert(slot, this.resourceConverter.toResource(ingredient), totalAmount, (TransactionContext)tx);
                if (inserted > 0) {
                    tx.commit();
                    long remaining = totalAmount - inserted;
                    T t = this.ingredientComponent.getMatcher().withQuantity(ingredient, remaining);
                    return t;
                }
            }
            return this.ingredientComponent.getMatcher().getEmptyInstance();
        }

        @Override
        public T extract(int slot, long maxQuantity, TransactionContext transaction) {
            Resource contents = this.storage.getResource(slot);
            if (!contents.isEmpty()) {
                try (Transaction tx = Transaction.open((TransactionContext)transaction);){
                    int extracted = this.storage.extract(slot, contents, IModHelpers.get().getBaseHelpers().castSafe(maxQuantity), (TransactionContext)tx);
                    if (extracted > 0) {
                        tx.commit();
                        T t = this.resourceConverter.fromResource(contents, extracted);
                        return t;
                    }
                }
            }
            return this.ingredientComponent.getMatcher().getEmptyInstance();
        }
    }

    public static class ResourceStorageWrapperSlotted<R extends Resource, T, M>
    extends ResourceStorageWrapper<R, T, M> {
        private final IIngredientComponentStorageSlotted<T, M> storage;

        public ResourceStorageWrapperSlotted(IIngredientComponentStorageSlotted<T, M> storage, IResourceConverter<R, T> resourceConverter) {
            super(storage, resourceConverter);
            this.storage = storage;
        }

        @Override
        public int size() {
            return this.storage.getSlots();
        }

        @Override
        public R getResource(int slot) {
            if (slot < 0 || slot >= this.size()) {
                throw new IndexOutOfBoundsException("Slot " + slot + " not in valid range - [0," + this.size() + ")");
            }
            return this.resourceConverter.toResource(this.storage.getSlotContents(slot));
        }

        @Override
        public long getAmountAsLong(int slot) {
            if (slot < 0 || slot >= this.size()) {
                throw new IndexOutOfBoundsException("Slot " + slot + " not in valid range - [0," + this.size() + ")");
            }
            return this.storage.getComponent().getMatcher().getQuantity(this.storage.getSlotContents(slot));
        }

        @Override
        public long getCapacityAsLong(int slot, R resource) {
            return IModHelpers.get().getBaseHelpers().castSafe(this.storage.getMaxQuantity(slot));
        }

        @Override
        public int insert(int slot, R resource, int amount, TransactionContext transaction) {
            T remaining;
            if (resource.isEmpty()) {
                return 0;
            }
            IIngredientMatcher matcher = this.storage.getComponent().getMatcher();
            return matcher.isEmpty(remaining = this.storage.insert(slot, this.resourceConverter.fromResource(resource, amount), transaction)) ? amount : amount - IModHelpers.get().getBaseHelpers().castSafe(matcher.getQuantity(remaining));
        }

        @Override
        public int extract(int slot, R resource, int amount, TransactionContext transaction) {
            if (resource.isEmpty()) {
                return 0;
            }
            IIngredientMatcher matcher = this.storage.getComponent().getMatcher();
            if (!matcher.matches(this.storage.getSlotContents(slot), this.resourceConverter.fromResource(resource, amount), matcher.getExactMatchNoQuantityCondition())) {
                return 0;
            }
            T extracted = this.storage.extract(slot, (long)amount, transaction);
            return IModHelpers.get().getBaseHelpers().castSafe(matcher.getQuantity(extracted));
        }
    }

    public static class ResourceStorageWrapper<R extends Resource, T, M>
    implements ResourceHandler<R> {
        private final IIngredientComponentStorage<T, M> storage;
        protected final IResourceConverter<R, T> resourceConverter;

        public ResourceStorageWrapper(IIngredientComponentStorage<T, M> storage, IResourceConverter<R, T> resourceConverter) {
            this.storage = storage;
            this.resourceConverter = resourceConverter;
        }

        public int size() {
            return Iterators.size(this.storage.iterator()) + 1;
        }

        public R getResource(int slot) {
            return this.resourceConverter.toResource(Iterables.get(this.storage, (int)slot, this.storage.getComponent().getMatcher().getEmptyInstance()));
        }

        public long getAmountAsLong(int slot) {
            return this.storage.getComponent().getMatcher().getQuantity(Iterables.get(this.storage, (int)slot, this.storage.getComponent().getMatcher().getEmptyInstance()));
        }

        public long getCapacityAsLong(int slot, R resource) {
            return IModHelpers.get().getBaseHelpers().castSafe(this.storage.getMaxQuantity());
        }

        public boolean isValid(int slot, R resource) {
            return true;
        }

        public int insert(int slot, R resource, int amount, TransactionContext transaction) {
            return this.insert(resource, amount, transaction);
        }

        public int insert(R resource, int amount, TransactionContext transaction) {
            T remaining;
            if (resource.isEmpty()) {
                return 0;
            }
            IIngredientMatcher<T, M> matcher = this.storage.getComponent().getMatcher();
            return matcher.isEmpty(remaining = this.storage.insert(this.resourceConverter.fromResource(resource, amount), transaction)) ? amount : amount - IModHelpers.get().getBaseHelpers().castSafe(matcher.getQuantity(remaining));
        }

        public int extract(int slot, R resource, int amount, TransactionContext transaction) {
            Object slotInstance;
            IIngredientMatcher<Object, M> matcher = this.storage.getComponent().getMatcher();
            if (matcher.isEmpty(slotInstance = Iterators.get(this.storage.iterator(), (int)slot, matcher.getEmptyInstance()))) {
                return 0;
            }
            Object extracted = this.storage.extract(slotInstance, matcher.getExactMatchNoQuantityCondition(), transaction);
            return IModHelpers.get().getBaseHelpers().castSafe(matcher.getQuantity(extracted));
        }

        public int extract(R resource, int amount, TransactionContext transaction) {
            if (resource.isEmpty()) {
                return 0;
            }
            IIngredientMatcher<T, M> matcher = this.storage.getComponent().getMatcher();
            T extracted = this.storage.extract(this.resourceConverter.fromResource(resource, amount), matcher.getExactMatchNoQuantityCondition(), transaction);
            return IModHelpers.get().getBaseHelpers().castSafe(matcher.getQuantity(extracted));
        }
    }
}

