/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla.capability;

import javax.annotation.Nullable;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public interface IVanillaEntityItemCapabilityDelegator {
    public ItemStack getItemStack();

    public void updateItemStack(ItemStack var1);

    public static class ItemAccessEntity
    implements ItemAccess {
        private final IVanillaEntityItemCapabilityDelegator delegator;
        private final SnapshotJournal<ItemStack> snapshotJournal;
        @Nullable
        private ItemStack uncommittedStack = null;

        public ItemAccessEntity(final IVanillaEntityItemCapabilityDelegator delegator) {
            this.delegator = delegator;
            this.snapshotJournal = new SnapshotJournal<ItemStack>(){

                protected ItemStack createSnapshot() {
                    return delegator.getItemStack().copy();
                }

                protected void revertToSnapshot(ItemStack itemResource) {
                    delegator.updateItemStack(itemResource);
                }

                protected void onRootCommit(ItemStack originalState) {
                    super.onRootCommit((Object)originalState);
                    if (uncommittedStack != null) {
                        delegator.updateItemStack(uncommittedStack);
                        uncommittedStack = null;
                    }
                }
            };
        }

        public ItemResource getResource() {
            return ItemResource.of((ItemStack)this.delegator.getItemStack());
        }

        public int getAmount() {
            return this.delegator.getItemStack().getCount();
        }

        public int insert(ItemResource itemResource, int amount, TransactionContext transactionContext) {
            if (this.delegator.getItemStack().isEmpty()) {
                this.snapshotJournal.updateSnapshots(transactionContext);
                this.delegator.updateItemStack(itemResource.toStack(amount));
                return amount;
            }
            return amount;
        }

        public int extract(ItemResource itemResource, int amount, TransactionContext transactionContext) {
            ItemStack stack = this.delegator.getItemStack();
            if (!stack.isEmpty()) {
                int extracted = Math.min(amount, stack.getCount());
                stack = stack.copy();
                stack.shrink(extracted);
                this.delegator.updateItemStack(stack);
                this.snapshotJournal.updateSnapshots(transactionContext);
                return extracted;
            }
            return 0;
        }

        public static ItemAccessEntity of(final ItemEntity entity) {
            return new ItemAccessEntity(new IVanillaEntityItemCapabilityDelegator(){

                @Override
                public ItemStack getItemStack() {
                    return entity.getItem();
                }

                @Override
                public void updateItemStack(ItemStack itemStack) {
                    entity.setItem(itemStack);
                }
            });
        }

        public static ItemAccessEntity of(final ItemFrame entity) {
            return new ItemAccessEntity(new IVanillaEntityItemCapabilityDelegator(){

                @Override
                public ItemStack getItemStack() {
                    return entity.getItem();
                }

                @Override
                public void updateItemStack(ItemStack itemStack) {
                    entity.setItem(itemStack);
                }
            });
        }
    }
}

