/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler;

import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.apache.commons.lang3.math.Fraction;
import org.cyclops.commoncapabilities.capability.itemhandler.ItemItemHandler;

public class VanillaItemBundleItemHandler
extends ItemItemHandler {
    public VanillaItemBundleItemHandler(ItemStack itemStack) {
        super(itemStack);
    }

    @Override
    protected NonNullList<ItemStack> getItemList() {
        BundleContents container = (BundleContents)this.getItemStack().get(DataComponents.BUNDLE_CONTENTS);
        if (container != null) {
            NonNullList list = NonNullList.create();
            container.itemCopyStream().forEach(arg_0 -> list.add(arg_0));
            list.add((Object)ItemStack.EMPTY);
            return list;
        }
        return NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    }

    @Override
    protected void setItemList(NonNullList<ItemStack> itemStacks) {
        this.getItemStack().set(DataComponents.BUNDLE_CONTENTS, (Object)new BundleContents(itemStacks.stream().filter(stack -> !stack.isEmpty()).toList()));
    }

    public int size() {
        return this.getItemList().size();
    }

    public long getCapacityAsLong(int slot, ItemResource itemResource) {
        return 64L;
    }

    public boolean isValid(int slot, ItemResource itemResource) {
        return itemResource.isEmpty() || itemResource.getItem().canFitInsideContainerItems();
    }

    protected boolean isAmountValid(ItemStack stack) {
        return this.getMaxAmountToAdd(stack) > 0;
    }

    @Override
    public int insert(int slot, ItemResource itemResource, int amount, TransactionContext transaction) {
        if (!this.isValid(slot, itemResource) || !this.isAmountValid(itemResource.toStack(amount))) {
            return 0;
        }
        return super.insert(slot, itemResource, amount, transaction);
    }

    private int getMaxAmountToAdd(ItemStack stackToAdd) {
        BundleContents container = (BundleContents)this.getItemStack().get(DataComponents.BUNDLE_CONTENTS);
        Fraction fraction = Fraction.ONE.subtract(container.weight());
        return Math.max(fraction.divideBy(BundleContents.getWeight((ItemStack)stackToAdd)).intValue(), 0);
    }
}

