/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.gametest;

import com.google.common.collect.Sets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Blocks;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.Capabilities;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.cyclopscore.gametest.GameTest;

public class GameTestsVanillaCapabilitiesRecipeHandler {
    public static final String TEMPLATE_EMPTY = "commoncapabilities:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 1, 2);

    @GameTest(template="commoncapabilities:empty10")
    public void testBlockRecipeHandlerCapBrewingStand(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.BREWING_STAND);
        helper.succeedIf(() -> {
            IRecipeHandler recipeHandler = (IRecipeHandler)helper.getLevel().getCapability(Capabilities.RecipeHandler.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(recipeHandler != null, (Component)Component.literal((String)"Recipe handler does not exist"));
            helper.assertValueEqual(recipeHandler.getRecipeInputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), (Component)Component.literal((String)"Input components are incorrect"));
            helper.assertValueEqual(recipeHandler.getRecipeOutputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), (Component)Component.literal((String)"Output components are incorrect"));
            helper.assertTrue(recipeHandler.getRecipes().size() >= 279, (Component)Component.literal((String)"Recipe count is less than 279"));
            for (IRecipeDefinition recipe : recipeHandler.getRecipes()) {
                helper.assertTrue(recipeHandler.simulate(MixedIngredients.fromRecipeInput(recipe)) != null, (Component)Component.literal((String)("Recipe simulation failed for " + String.valueOf(recipe))));
            }
        });
    }

    @GameTest(template="commoncapabilities:empty10")
    public void testBlockRecipeHandlerCapFurnace(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.FURNACE);
        helper.succeedIf(() -> {
            IRecipeHandler recipeHandler = (IRecipeHandler)helper.getLevel().getCapability(Capabilities.RecipeHandler.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(recipeHandler != null, (Component)Component.literal((String)"Recipe handler does not exist"));
            helper.assertValueEqual(recipeHandler.getRecipeInputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), (Component)Component.literal((String)"Input components are incorrect"));
            helper.assertValueEqual(recipeHandler.getRecipeOutputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), (Component)Component.literal((String)"Output components are incorrect"));
            helper.assertTrue(recipeHandler.getRecipes().size() >= 70, (Component)Component.literal((String)"Recipe count is less than 70"));
            for (IRecipeDefinition recipe : recipeHandler.getRecipes()) {
                helper.assertTrue(recipeHandler.simulate(MixedIngredients.fromRecipeInput(recipe)) != null, (Component)Component.literal((String)("Recipe simulation failed for " + String.valueOf(recipe))));
            }
        });
    }

    @GameTest(template="commoncapabilities:empty10")
    public void testBlockRecipeHandlerCapBlastFurnace(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.BLAST_FURNACE);
        helper.succeedIf(() -> {
            IRecipeHandler recipeHandler = (IRecipeHandler)helper.getLevel().getCapability(Capabilities.RecipeHandler.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(recipeHandler != null, (Component)Component.literal((String)"Recipe handler does not exist"));
            helper.assertValueEqual(recipeHandler.getRecipeInputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), (Component)Component.literal((String)"Input components are incorrect"));
            helper.assertValueEqual(recipeHandler.getRecipeOutputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), (Component)Component.literal((String)"Output components are incorrect"));
            helper.assertTrue(recipeHandler.getRecipes().size() >= 24, (Component)Component.literal((String)"Recipe count is less than 24"));
            for (IRecipeDefinition recipe : recipeHandler.getRecipes()) {
                helper.assertTrue(recipeHandler.simulate(MixedIngredients.fromRecipeInput(recipe)) != null, (Component)Component.literal((String)("Recipe simulation failed for " + String.valueOf(recipe))));
            }
        });
    }

    @GameTest(template="commoncapabilities:empty10")
    public void testBlockRecipeHandlerCapSmoker(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.SMOKER);
        helper.succeedIf(() -> {
            IRecipeHandler recipeHandler = (IRecipeHandler)helper.getLevel().getCapability(Capabilities.RecipeHandler.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(recipeHandler != null, (Component)Component.literal((String)"Recipe handler does not exist"));
            helper.assertValueEqual(recipeHandler.getRecipeInputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), (Component)Component.literal((String)"Input components are incorrect"));
            helper.assertValueEqual(recipeHandler.getRecipeOutputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), (Component)Component.literal((String)"Output components are incorrect"));
            helper.assertTrue(recipeHandler.getRecipes().size() >= 9, (Component)Component.literal((String)"Recipe count is less than 9"));
            for (IRecipeDefinition recipe : recipeHandler.getRecipes()) {
                helper.assertTrue(recipeHandler.simulate(MixedIngredients.fromRecipeInput(recipe)) != null, (Component)Component.literal((String)("Recipe simulation failed for " + String.valueOf(recipe))));
            }
        });
    }

    @GameTest(template="commoncapabilities:empty10")
    public void testBlockRecipeHandlerCapCampFire(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.CAMPFIRE);
        helper.succeedIf(() -> {
            IRecipeHandler recipeHandler = (IRecipeHandler)helper.getLevel().getCapability(Capabilities.RecipeHandler.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(recipeHandler != null, (Component)Component.literal((String)"Recipe handler does not exist"));
            helper.assertValueEqual(recipeHandler.getRecipeInputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), (Component)Component.literal((String)"Input components are incorrect"));
            helper.assertValueEqual(recipeHandler.getRecipeOutputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), (Component)Component.literal((String)"Output components are incorrect"));
            helper.assertTrue(recipeHandler.getRecipes().size() >= 9, (Component)Component.literal((String)"Recipe count is less than 9"));
            for (IRecipeDefinition recipe : recipeHandler.getRecipes()) {
                helper.assertTrue(recipeHandler.simulate(MixedIngredients.fromRecipeInput(recipe)) != null, (Component)Component.literal((String)("Recipe simulation failed for " + String.valueOf(recipe))));
            }
        });
    }

    @GameTest(template="commoncapabilities:empty10")
    public void testBlockRecipeHandlerCapCrafingTable(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.CRAFTING_TABLE);
        helper.succeedIf(() -> {
            IRecipeHandler recipeHandler = (IRecipeHandler)helper.getLevel().getCapability(Capabilities.RecipeHandler.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(recipeHandler != null, (Component)Component.literal((String)"Recipe handler does not exist"));
            helper.assertValueEqual(recipeHandler.getRecipeInputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), (Component)Component.literal((String)"Input components are incorrect"));
            helper.assertValueEqual(recipeHandler.getRecipeOutputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), (Component)Component.literal((String)"Output components are incorrect"));
            helper.assertTrue(recipeHandler.getRecipes().size() >= 964, (Component)Component.literal((String)"Recipe count is less than 964"));
            for (IRecipeDefinition recipe : recipeHandler.getRecipes()) {
                helper.assertTrue(recipeHandler.simulate(MixedIngredients.fromRecipeInput(recipe)) != null, (Component)Component.literal((String)("Recipe simulation failed for " + String.valueOf(recipe))));
            }
        });
    }

    @GameTest(template="commoncapabilities:empty10")
    public void testBlockRecipeHandlerCapStoneCutter(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.STONECUTTER);
        helper.succeedIf(() -> {
            IRecipeHandler recipeHandler = (IRecipeHandler)helper.getLevel().getCapability(Capabilities.RecipeHandler.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(recipeHandler != null, (Component)Component.literal((String)"Recipe handler does not exist"));
            helper.assertValueEqual(recipeHandler.getRecipeInputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), (Component)Component.literal((String)"Input components are incorrect"));
            helper.assertValueEqual(recipeHandler.getRecipeOutputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), (Component)Component.literal((String)"Output components are incorrect"));
            helper.assertTrue(recipeHandler.getRecipes().size() >= 250, (Component)Component.literal((String)"Recipe count is less than 250"));
            for (IRecipeDefinition recipe : recipeHandler.getRecipes()) {
                helper.assertTrue(recipeHandler.simulate(recipe) != null, (Component)Component.literal((String)("Recipe simulation failed for " + String.valueOf(recipe))));
            }
        });
    }

    @GameTest(template="commoncapabilities:empty10")
    public void testBlockRecipeHandlerCapSmithingTable(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.SMITHING_TABLE);
        helper.succeedIf(() -> {
            IRecipeHandler recipeHandler = (IRecipeHandler)helper.getLevel().getCapability(Capabilities.RecipeHandler.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(recipeHandler != null, (Component)Component.literal((String)"Recipe handler does not exist"));
            helper.assertValueEqual(recipeHandler.getRecipeInputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), (Component)Component.literal((String)"Input components are incorrect"));
            helper.assertValueEqual(recipeHandler.getRecipeOutputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), (Component)Component.literal((String)"Output components are incorrect"));
            helper.assertTrue(recipeHandler.getRecipes().size() >= 0, (Component)Component.literal((String)"Recipe count is less than 0"));
            for (IRecipeDefinition recipe : recipeHandler.getRecipes()) {
                helper.assertTrue(recipeHandler.simulate(MixedIngredients.fromRecipeInput(recipe)) != null, (Component)Component.literal((String)("Recipe simulation failed for " + String.valueOf(recipe))));
            }
        });
    }
}

