/*
 * Decompiled with CFR 0.152.
 */
package net.nhatjs.js_furniture_mod.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nhatjs.js_furniture_mod.entity.ModEntities;

public class SofaBlock
extends Block {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<Part> PART = EnumProperty.create((String)"part", Part.class);
    private static final MapCodec<SofaBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)DyeColor.CODEC.fieldOf("color").forGetter(block -> block.color), (App)SofaBlock.propertiesCodec()).apply((Applicative)builder, SofaBlock::new));
    private final DyeColor color;

    public SofaBlock(DyeColor color, BlockBehaviour.Properties settings) {
        super(settings);
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)((Object)Part.SINGLE)));
    }

    public DyeColor getColor() {
        return this.color;
    }

    public MapCodec<SofaBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, PART});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction facing = ctx.getHorizontalDirection();
        BlockState state = (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)facing);
        if (state != null) {
            return (BlockState)state.setValue(PART, (Comparable)((Object)this.getShape(state, (LevelReader)ctx.getLevel(), ctx.getClickedPos())));
        }
        return null;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue(FACING)) {
            default: 
        }
        return Block.box((double)0.0, (double)0.5, (double)0.0, (double)16.0, (double)7.525, (double)16.0);
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return (BlockState)state.setValue(PART, (Comparable)((Object)this.getShape(state, (LevelReader)level, pos)));
    }

    public Part getShape(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.getValue(FACING);
        Direction front = this.getSofaState(level, pos, facing.getOpposite());
        if (front != null) {
            if (front == facing.getClockWise()) {
                return Part.CORNER_RIGHT;
            }
            if (front == facing.getCounterClockWise()) {
                return Part.CORNER_LEFT;
            }
        }
        boolean left = this.isConnectable(level, pos, facing, facing.getCounterClockWise());
        boolean right = this.isConnectable(level, pos, facing, facing.getClockWise());
        if (left && right) {
            return Part.MIDDLE;
        }
        if (left) {
            return Part.RIGHT;
        }
        if (right) {
            return Part.LEFT;
        }
        return Part.SINGLE;
    }

    private Direction getSofaState(LevelReader level, BlockPos pos, Direction side) {
        BlockState relativeState = level.getBlockState(pos.relative(side));
        return relativeState.getBlock() instanceof SofaBlock ? (Direction)relativeState.getValue(FACING) : null;
    }

    private boolean isConnectable(LevelReader level, BlockPos pos, Direction facing, Direction offset) {
        BlockPos relativePos = pos.relative(offset);
        BlockState relativeState = level.getBlockState(pos.relative(offset));
        if (relativeState.getBlock() instanceof SofaBlock) {
            Direction other = (Direction)relativeState.getValue(FACING);
            return other == facing || other == offset;
        }
        return relativeState.isFaceSturdy((BlockGetter)level, relativePos, offset.getOpposite());
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!level.isClientSide()) {
            Entity entity = null;
            List entities = level.getEntities((EntityTypeTest)ModEntities.SOFA.get(), new AABB(pos), seatBlockEntity -> true);
            entity = entities.isEmpty() ? ModEntities.SOFA.get().spawn((ServerLevel)level, pos, MobSpawnType.TRIGGERED) : (Entity)entities.get(0);
            player.startRiding(entity);
        }
        return InteractionResult.SUCCESS;
    }

    public static enum Part implements StringRepresentable
    {
        SINGLE("single"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle"),
        CORNER_LEFT("corner_left"),
        CORNER_RIGHT("corner_right");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

