/*
 * Decompiled with CFR 0.152.
 */
package net.nhatjs.js_furniture_mod.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TVBlock
extends Block {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<Mount> MOUNT = EnumProperty.create((String)"mount", Mount.class);
    private static final VoxelShape NORTH_MOUNT = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_MOUNT = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape WEST_MOUNT = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_MOUNT = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_STAND = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)15.0, (double)15.0);
    private static final VoxelShape SOUTH_STAND = Block.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)15.0, (double)2.0);
    private static final VoxelShape WEST_STAND = Block.box((double)14.0, (double)0.0, (double)0.0, (double)15.0, (double)15.0, (double)16.0);
    private static final VoxelShape EAST_STAND = Block.box((double)1.0, (double)0.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0);

    public TVBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue(MOUNT, (Comparable)((Object)Mount.STAND)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, MOUNT});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue(FACING);
        boolean wall = state.getValue(MOUNT) == Mount.WALL;
        return switch ((Direction)state.getValue(FACING)) {
            default -> {
                if (wall) {
                    yield NORTH_MOUNT;
                }
                yield Shapes.or((VoxelShape)NORTH_STAND, (VoxelShape[])new VoxelShape[0]);
            }
            case Direction.SOUTH -> {
                if (wall) {
                    yield SOUTH_MOUNT;
                }
                yield Shapes.or((VoxelShape)SOUTH_STAND, (VoxelShape[])new VoxelShape[0]);
            }
            case Direction.EAST -> {
                if (wall) {
                    yield EAST_MOUNT;
                }
                yield Shapes.or((VoxelShape)EAST_STAND, (VoxelShape[])new VoxelShape[0]);
            }
            case Direction.WEST -> wall ? WEST_MOUNT : Shapes.or((VoxelShape)WEST_STAND, (VoxelShape[])new VoxelShape[0]);
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction face = ctx.getClickedFace();
        if (face.getAxis().isHorizontal()) {
            BlockPos back = ctx.getClickedPos().offset(face.getOpposite().getNormal());
            if (this.hasSupport((LevelAccessor)ctx.getLevel(), back, face)) {
                return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)face)).setValue(MOUNT, (Comparable)((Object)Mount.WALL));
            }
            return null;
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue(MOUNT, (Comparable)((Object)Mount.STAND));
    }

    private boolean hasSupport(LevelAccessor world, BlockPos pos, Direction supportFace) {
        BlockState bs = world.getBlockState(pos);
        return bs.isFaceSturdy((BlockGetter)world, pos, supportFace) || bs.isRedstoneConductor((BlockGetter)world, pos);
    }

    public static enum Mount implements StringRepresentable
    {
        STAND("stand"),
        WALL("wall");

        private final String name;

        private Mount(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

