/*
 * Decompiled with CFR 0.152.
 */
package net.nhatjs.js_furniture_mod.block.blockentity.client;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.nhatjs.js_furniture_mod.block.CoffeeTableBlock;
import net.nhatjs.js_furniture_mod.block.blockentity.ModBlockEntities;

public class CoffeeTableBlockEntity
extends BlockEntity {
    private ItemStack stack = ItemStack.EMPTY;
    private int renderNonce = 0;

    public CoffeeTableBlockEntity(BlockPos pos, BlockState s) {
        super(ModBlockEntities.COFFEE_TABLE.get(), pos, s);
    }

    public ItemStack getItem() {
        return this.stack;
    }

    public int getRenderNonce() {
        return this.renderNonce;
    }

    public void setItem(ItemStack s) {
        this.stack = s == null ? ItemStack.EMPTY : s;
        ++this.renderNonce;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)CoffeeTableBlock.HAS_ITEM, (Comparable)Boolean.valueOf(!this.stack.isEmpty())), 3);
            ((ServerLevel)this.level).getChunkSource().blockChanged(this.getBlockPos());
        }
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        if (!this.stack.isEmpty()) {
            output.store("it", ItemStack.CODEC, (Object)this.stack);
        }
        output.putInt("rn", this.renderNonce);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.stack = input.read("it", ItemStack.CODEC).orElse(ItemStack.EMPTY);
        this.renderNonce = input.getIntOr("rn", 0);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider register) {
        return this.saveWithoutMetadata(register);
    }
}

