/*
 * Decompiled with CFR 0.152.
 */
package net.nhatjs.js_furniture_mod.block.blockentity.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.nhatjs.js_furniture_mod.NhatJSFurnitureModClient;
import net.nhatjs.js_furniture_mod.block.ModBlocks;
import net.nhatjs.js_furniture_mod.block.blockentity.client.CeilingFanBlockEntity;
import org.joml.Quaternionfc;

public class CeilingFanRenderer
implements BlockEntityRenderer<CeilingFanBlockEntity> {
    private final BlockStateModel blades_black = (BlockStateModel)Minecraft.getInstance().getModelManager().getStandaloneModel(NhatJSFurnitureModClient.CEILING_FAN_BLADES_ID);
    private final BlockStateModel blades_white = (BlockStateModel)Minecraft.getInstance().getModelManager().getStandaloneModel(NhatJSFurnitureModClient.CEILING_FAN_BLADES_B_ID);

    public CeilingFanRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(CeilingFanBlockEntity be, float tickDelta, PoseStack ps, MultiBufferSource buf, int light, int overlay, Vec3 vec3) {
        Level level = be.getLevel();
        if (level == null) {
            return;
        }
        BlockPos pos = be.getBlockPos();
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        if (this.blades_black == null || this.blades_white == null || this.blades_black == Minecraft.getInstance().getModelManager().getMissingBlockStateModel() || this.blades_white == Minecraft.getInstance().getModelManager().getMissingBlockStateModel()) {
            return;
        }
        ps.pushPose();
        ps.translate(0.5, 0.9375, 0.5);
        ps.mulPose((Quaternionfc)Axis.YP.rotationDegrees(be.getAngle(tickDelta)));
        float blur = Math.min(be.speed / 27.0f, 1.0f);
        float alpha = 1.0f - blur * 0.4f;
        ps.translate(-0.5, -0.9375, -0.5);
        VertexConsumer vc = buf.getBuffer(RenderType.cutoutMipped());
        if (level.getBlockState(BlockPos.containing((double)x, (double)y, (double)z)).getBlock() == ModBlocks.CEILING_FAN.get()) {
            Minecraft.getInstance().getBlockRenderer().getModelRenderer();
            ModelBlockRenderer.renderModel((PoseStack.Pose)ps.last(), (VertexConsumer)vc, (BlockStateModel)this.blades_black, (float)1.0f, (float)1.0f, (float)1.0f, (int)light, (int)overlay);
        } else if (level.getBlockState(BlockPos.containing((double)x, (double)y, (double)z)).getBlock() == ModBlocks.CEILING_FAN_B.get()) {
            Minecraft.getInstance().getBlockRenderer().getModelRenderer();
            ModelBlockRenderer.renderModel((PoseStack.Pose)ps.last(), (VertexConsumer)vc, (BlockStateModel)this.blades_white, (float)1.0f, (float)1.0f, (float)1.0f, (int)light, (int)overlay);
        }
        ps.popPose();
    }
}

