/*
 * Decompiled with CFR 0.152.
 */
package net.nhatjs.js_furniture_mod.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LEDFloorLampBlock
extends Block {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty TURN_ON = BooleanProperty.create((String)"turn_on");
    private static final VoxelShape HORIZONTAL = Shapes.or((VoxelShape)Block.box((double)7.0, (double)0.5, (double)7.5, (double)9.0, (double)29.75, (double)8.5), (VoxelShape)Block.box((double)5.75, (double)0.0, (double)5.75, (double)10.25, (double)0.5, (double)10.25));
    private static final VoxelShape VERTICAL = Shapes.or((VoxelShape)Block.box((double)7.5, (double)0.5, (double)7.0, (double)8.5, (double)29.75, (double)9.0), (VoxelShape)Block.box((double)5.75, (double)0.0, (double)5.75, (double)10.25, (double)0.5, (double)10.25));

    public LEDFloorLampBlock(BlockBehaviour.Properties settings) {
        super(settings.lightLevel(st -> (Boolean)st.getValue((Property)TURN_ON) != false ? 12 : 0));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)TURN_ON, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> HORIZONTAL;
            case Direction.SOUTH -> HORIZONTAL;
            case Direction.EAST -> VERTICAL;
            case Direction.WEST -> VERTICAL;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TURN_ON});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!level.isClientSide()) {
            boolean current = (Boolean)state.getValue((Property)TURN_ON);
            level.setBlock(pos, (BlockState)state.setValue((Property)TURN_ON, (Comparable)Boolean.valueOf(!current)), 3);
        }
        return InteractionResult.SUCCESS;
    }
}

