package win.baruna.blockmeter;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigManager;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1269;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_746;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.glfw.GLFW;
import win.baruna.blockmeter.gui.EditBoxGui;
import win.baruna.blockmeter.gui.OptionsGui;
import win.baruna.blockmeter.gui.SelectBoxGui;
import win.baruna.blockmeter.measurebox.ClientMeasureBox;

import java.util.*;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

@SuppressWarnings("UnstableApiUsage")
public class BlockMeterClient implements ClientModInitializer {
    /**
     * Currently running Instance of BlockMeterClient
     */
    private static BlockMeterClient instance;

    /**
     * Accessor for the BlockMeterClient Instance
     *
     * @return running Instance of BlockMeterClient
     */
    public static BlockMeterClient getInstance() {
        return instance;
    }

    private static class_746 getPlayer() {
        return Objects.requireNonNull(class_310.method_1551().field_1724);
    }

    /**
     * ConfigManager of BlockMeter
     */
    private static ConfigManager<ModConfig> confMgr;

    /**
     * Accessor for the ModConfigManager
     *
     * @return ConfigManager for handling the Config
     */
    public static ConfigManager<ModConfig> getConfigManager() {

        return confMgr;
    }

    public static ModConfig getConfig() {
        return confMgr.getConfig();
    }

    /**
     * The current state of the BlockMeter (activated/deactivated)
     */
    private boolean active;

    /**
     * The Item selected as BlockMeter
     */
    private class_1792 currentItem;

    /**
     * The List of Measuring-Boxes currently created by the current User
     */
    private final List<ClientMeasureBox> boxes = new ArrayList<>();

    /**
     * A Map of Lists of Boxes currently created by other Users, with Text being the
     * Username
     */
    private Map<String, List<ClientMeasureBox>> otherUsersBoxes;

    /**
     * The QuickMenu for changing of Color etc.
     */
    private final OptionsGui quickMenu;

    /**
     * The QuickMenu for selecting on of multiple Boxes.
     */
    private final SelectBoxGui selectBoxGui;
    private final EditBoxGui editBoxGui;

    public BlockMeterClient() {
        active = false;
        quickMenu = new OptionsGui();
        selectBoxGui = new SelectBoxGui();
        editBoxGui = new EditBoxGui();
        otherUsersBoxes = null;
        BlockMeterClient.instance = this;
    }

    /**
     * Disables BlockMeter
     */
    public void disable() {
        active = false;
        currentItem = null;
        boxes.clear();
        if (confMgr.getConfig().deleteBoxesOnDisable) {
            clear();
        }
    }

    /**
     * Resets Blockmeter to be used in another World
     */
    public void reset() {
        otherUsersBoxes = null;
        boxes.clear();
        disable();

        // Resets Color to always start with white in another world
        ModConfig cfg = confMgr.getConfig();
        if (cfg.incrementColor) {
            cfg.colorIndex = 0;
            confMgr.save();
        }
    }

    /**
     * Clears Boxes and sends this information to the server
     */
    public boolean clear() {
        boolean hasBox = !boxes.isEmpty();
        boxes.clear();
        sendBoxList();

        // Reset the color as all Boxes where deleted
        ModConfig cfg = confMgr.getConfig();
        if (cfg.incrementColor) {
            cfg.colorIndex = 0;
            confMgr.save();
        }
        return hasBox;
    }

    /**
     * Removes the last box
     */
    public boolean undo() {
        if (this.boxes.isEmpty())
            return false;

        this.boxes.remove(this.boxes.size() - 1);
        sendBoxList();

        ModConfig cfg = confMgr.getConfig();
        if (cfg.incrementColor) {
            cfg.colorIndex = Math.floorMod(cfg.colorIndex - 1, class_1767.values().length);
            confMgr.save();
        }

        return true;
    }

    public void renderOverlay(WorldRenderContext context) {
        final class_2960 currentDimension = getPlayer().field_17892.method_27983().method_29177();

        final ModConfig cfg = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

        // MEH! but this seems to be needed to get the first background
        // rectangle
        //        client.textRenderer.draw("XXX", stack,  -100, -100, 0);

        if (this.active || cfg.showBoxesWhenDisabled)
            if (cfg.showOtherUsersBoxes) {
                if (otherUsersBoxes != null && !otherUsersBoxes.isEmpty()) {
                    this.otherUsersBoxes.forEach((playerText, boxList) -> boxList.forEach(box -> box.render(
                            context, currentDimension, class_2561.method_43470(playerText))));
                    this.boxes.forEach(box -> {
                        if (!box.isFinished())
                            box.render(context, currentDimension);
                    });
                }
                if (!cfg.sendBoxes)
                    this.boxes.forEach(box -> {
                        if (box.isFinished())
                            box.render(context, currentDimension, getPlayer().method_5476());
                        else
                            box.render(context, currentDimension);
                    });
            } else
                this.boxes.forEach(box -> box.render(context, currentDimension));

    }

    /**
     * Gets Triggered when the Player disconnects from the Server
     */
    public void onDisconnected(class_634 clientPlayNetworkHandler, class_310 minecraftClient) {
        reset();
    }

    /**
     * Gets Triggered when the Player connects to the Server
     */
    private void onConnected(class_634 clientPlayNetworkHandler, PacketSender packetSender,
                             class_310 minecraftClient) {
        sendBoxList(); // to make the server send other user's boxes
    }

    /**
     * Returns the currently active box
     *
     * @return currently open box or null if none
     */
    public ClientMeasureBox getCurrentBox() {
        return boxes.stream().filter(box -> !box.isFinished()).findAny().orElse(null);
    }

    @Override
    public void onInitializeClient() {
        final class_304 keyBinding = KeyBindingHelper.registerKeyBinding(new class_304("key.blockmeter.assign",
                class_3675.class_307.field_1668, GLFW.GLFW_KEY_M, "category.blockmeter.key"));
        final class_304 keyBindingMenu = new class_304("key.blockmeter.menu", class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_LEFT_ALT, "category.blockmeter.key");
        KeyBindingHelper.registerKeyBinding(keyBindingMenu);

        final class_304 keyBindingMeasureWithItem = new class_304("key.blockmeter.useItem", -1,
                "category.blockmeter.key");
        KeyBindingHelper.registerKeyBinding(keyBindingMeasureWithItem);
        final class_304 keyBindingMeasure = new class_304("key.blockmeter.measure", class_3675.class_307.field_1672,
                GLFW.GLFW_MOUSE_BUTTON_4, "category.blockmeter.key");
        KeyBindingHelper.registerKeyBinding(keyBindingMeasure);

        WorldRenderEvents.BEFORE_DEBUG_RENDER.register(this::renderOverlay);

        ClientPlayConnectionEvents.DISCONNECT.register(this::onDisconnected);
        ClientPlayConnectionEvents.JOIN.register(this::onConnected);
        ClientPlayNetworking.registerGlobalReceiver(BoxPayload.ID, this::handleServerBoxList);

        AtomicBoolean measureWithItemDown = new AtomicBoolean(false);

        // This is ugly I know, but I did not find something better
        // (Issue in AutoConfig https://github.com/shedaniel/AutoConfig/issues/13)
        confMgr = (ConfigManager<ModConfig>) AutoConfig.register(ModConfig.class, Toml4jConfigSerializer::new);
        ClientTickEvents.START_CLIENT_TICK.register(e -> {
            if (keyBinding.method_1436()) {
                if (class_437.method_25442()) {
                    if (undo())
                        getPlayer().method_7353(class_2561.method_43471("blockmeter.clearLast"), true);
                } else if (class_437.method_25441()) {
                    if (clear())
                        getPlayer().method_7353(class_2561.method_43471("blockmeter.clearAll"), true);
                } else if (this.active) {
                    disable();
                    getPlayer().method_7353(class_2561.method_43471("blockmeter.toggle.off"), true);
                } else {
                    active = true;
                    class_1799 itemStack = getPlayer().method_6047();
                    currentItem = itemStack.method_7909();
                    getPlayer().method_7353(
                            class_2561.method_43469("blockmeter.toggle.on", itemStack.method_63693()),
                            true);
                }
            }

            if (keyBindingMenu.method_1436() && active) {
                class_310.method_1551().method_1507(this.quickMenu);
            }

            if (keyBindingMeasure.method_1436()) {
                this.active = true;
                raycastBlock().ifPresent(this::onBlockMeterClick);
            }

            // Updates Selection preview
            if (this.active && !this.boxes.isEmpty()) {
                final ClientMeasureBox currentBox = getCurrentBox();
                if (currentBox != null) {
                    this.raycastBlock().ifPresent(currentBox::setBlockEnd);
                }
            }

            if (this.active) {
                var key = KeyBindingHelper.getBoundKeyOf(keyBindingMeasureWithItem);
                var pressed = false;
                if (key.method_1444() == -1) {
                    pressed = GLFW.glfwGetMouseButton(class_310.method_1551().method_22683().method_4490(), 1) == 1;
                } else {
                    switch (key.method_1442()) {
                        case field_1668, field_1671 -> pressed = GLFW.glfwGetKey(class_310.method_1551().method_22683()
                                .method_4490(), key.method_1444()) == 1;
                        case field_1672 -> pressed = GLFW.glfwGetMouseButton(class_310.method_1551().method_22683()
                                .method_4490(), key.method_1444()) == 1;
                    }
                }
                if (pressed) {
                    if (!measureWithItemDown.get()) {
                        measureWithItemDown.set(true);
                        if (getPlayer().method_6047().method_7909().equals(this.currentItem)) {
                            raycastBlock().ifPresent(this::onBlockMeterClick);
                        }
                    }
                } else {
                    measureWithItemDown.set(false);
                }
            }
        });

        UseItemCallback.EVENT.register((playerEntity, world, _hand) -> {
            if (this.active && playerEntity.method_6047().method_7909().equals(this.currentItem)) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        UseBlockCallback.EVENT.register((playerEntity, world, _hand, _block) -> {
            if (this.active && playerEntity.method_6047().method_7909().equals(this.currentItem)) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        AttackBlockCallback.EVENT.register(((player, world, hand, pos, direction) -> {
            var inside = this.boxes.stream()
                    .filter(box -> box.miningRestriction == ClientMeasureBox.MiningRestriction.Inside)
                    .anyMatch(box -> !box.contains(pos));
            var outside = this.boxes.stream()
                    .filter(box -> box.miningRestriction == ClientMeasureBox.MiningRestriction.Outside)
                    .anyMatch(box -> box.contains(pos));
            if (!class_437.method_25442() && (inside || outside)) {
                return class_1269.field_5814;
            } else {
                return class_1269.field_5811;
            }
        }));
    }

    private Optional<class_2338> raycastBlock() {
        var camera = class_310.method_1551().method_1560();
        if (camera == null) {
            return Optional.empty();
        }
        final class_239 rayHit = camera.method_5745(BlockMeterClient.getConfig().reach, 0.0f, false);
        if (rayHit.method_17783() == class_239.class_240.field_1332) {
            final class_3965 blockHitResult = (class_3965) rayHit;
            return Optional.of(blockHitResult.method_17777());
        }
        return Optional.empty();
    }

    public void editBox(ClientMeasureBox box, class_2338 block) {
        this.editBoxGui.setBox(box);
        this.editBoxGui.setBlock(block);
        class_310.method_1551().method_1507(this.editBoxGui);
    }

    /**
     * Handles the right click Event for creating and confirming new Measuring-Boxes
     */
    private void onBlockMeterClick(final class_2338 block) {
        ClientMeasureBox currentBox = getCurrentBox();

        if (currentBox == null) {
            if (class_437.method_25442()) {
                ClientMeasureBox[] boxes = findBoxes(block);
                switch (boxes.length) {
                    case 0:
                        break;
                    case 1:
                        editBox(boxes[0], block);
                        break;
                    default:
                        this.selectBoxGui.setBoxes(boxes);
                        this.selectBoxGui.setBlock(block);
                        class_310.method_1551().method_1507(this.selectBoxGui);
                        break;
                }
            } else {
                final ClientMeasureBox box = ClientMeasureBox.getBox(block,
                        getPlayer().method_37908().method_27983().method_29177());
                this.boxes.add(box);
            }
        } else {
            currentBox.setBlockEnd(block);
            currentBox.setFinished();
            sendBoxList();
        }
    }

    /**
     * Finds a box to be edited when selecting this block
     *
     * @param block selected block
     * @return Box to be edited
     */
    private ClientMeasureBox[] findBoxes(class_2338 block) {
        return boxes.stream().filter(box -> box.isCorner(block)).toArray(ClientMeasureBox[]::new);
    }

    /**
     * Sends BoxList to Server if enabled in the config
     */
    private void sendBoxList() {
        if (!AutoConfig.getConfigHolder(ModConfig.class).getConfig().sendBoxes)
            return;
        ClientPlayNetworking.send(new BoxPayload(Map.of("", new ArrayList<>(boxes))));
    }

    /**
     * handles the BoxList of other Players
     */
    private void handleServerBoxList(BoxPayload payload, ClientPlayNetworking.Context context) {
        context.client().method_18859(() -> otherUsersBoxes = payload.receivedBoxes().entrySet().stream()
                .map(entry -> Pair.of(entry.getKey(), entry.getValue().stream().map(ClientMeasureBox::new)
                        .toList()))
                .collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
    }

}
