package win.baruna.blockmeter;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import win.baruna.blockmeter.measurebox.MeasureBox;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class BlockMeterServer implements ModInitializer {

    private final Map<UUID, List<MeasureBox>> playerBoxes = new HashMap<>();
    private MinecraftServer server;
    private static BlockMeterServer instance;

    @Override
    public void onInitialize() {

        instance = this;
        PayloadTypeRegistry.playS2C().register(BoxPayload.ID, BoxPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(BoxPayload.ID, BoxPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(BoxPayload.ID, this::processClientPacket);
        ServerLifecycleEvents.SERVER_STARTED.register(this::onStartServer);
        ServerPlayConnectionEvents.DISCONNECT.register((b, a) -> {
            System.out.printf("DISCONNECTD %s%n", b.field_14140.method_5667());
        });
    }

    /**
     * Removes a player from the BoxMap
     *
     * @param player Player to be removed
     */
    public static void removePlayer(class_3222 player) {
        if (instance != null) {
            if (instance.playerBoxes.containsKey(player.method_5667())) {
                instance.playerBoxes.remove(player.method_5667());
                instance.informAllPlayers();
            }
        }
    }

    /**
     * Handles ServerStart
     */
    private void onStartServer(MinecraftServer server) {
        this.server = server;
    }

    /**
     * Processes a ClientPacket
     */

    private void processClientPacket(BoxPayload payload, ServerPlayNetworking.Context context) {
        try {
            var boxes = payload.receivedBoxes().values().stream().findFirst().orElse(List.of());
            synchronized (playerBoxes) {
                playerBoxes.put(context.player().method_5667(), boxes);
            }
        } catch (IllegalArgumentException ex) {
            synchronized (playerBoxes) {
                playerBoxes.remove(context.player().method_5667());
            }
        }

        server.execute(this::informAllPlayers);
    }

    /**
     * Informs all Players about the current boxList
     */
    private void informAllPlayers() {
        BoxPayload data = buildS2CPacket();
        for (class_3222 player : server.method_3760().method_14571()) {
            ServerPlayNetworking.send(player, data);
        }
    }

    /**
     * Builds a S2CPacket containing the BoxList
     *
     * @return S2CPacket containing the BoxList
     */
    private BoxPayload buildS2CPacket() {
        var data = new HashMap<String, List<MeasureBox>>();
        synchronized (playerBoxes) {
            for (var playerBoxEntry : playerBoxes.entrySet()) {
                class_3222 player = server.method_3760().method_14602(playerBoxEntry.getKey());
                if (player != null) {
                    data.put(player.method_5820(), playerBoxEntry.getValue());
                }
            }
        }
        return new BoxPayload(data);
    }
}
