package win.baruna.blockmeter;

import win.baruna.blockmeter.measurebox.MeasureBox;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public record BoxPayload(Map<String, List<MeasureBox>> receivedBoxes) implements class_8710 {
    public static final class_9139<class_2540, BoxPayload> CODEC =
            class_8710.method_56484(BoxPayload::write, BoxPayload::new);

    private void write(class_2540 data) {
        data.method_53002(receivedBoxes.size());
        for (var player : receivedBoxes.entrySet()) {
            data.method_10814(player.getKey());
            data.method_53002(player.getValue().size());
            for (int i = 0; i < player.getValue().size(); i++) {
                player.getValue().get(i).writePacketBuf(data);
            }
        }
    }

    public static final class_9154<BoxPayload> ID = new class_9154<>(class_2960.method_60655(BlockMeter.MOD_ID, "boxes"));

    public BoxPayload(class_2540 data) {
        this(new HashMap<>());

        var playerCount = data.readInt();
        for (var i = 0; i < playerCount; i++) {
            var playerName = data.method_19772();
            int boxCount = data.readInt();
            var boxes = new ArrayList<MeasureBox>(boxCount);
            for (var j = 0; j < boxCount; j++) {
                boxes.add(MeasureBox.fromPacketByteBuf(data));
            }
            receivedBoxes.put(playerName, boxes);
        }
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return ID;
    }
}
